/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.activeobjects.spi.AbstractRestoreProgressMonitor;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.HotRestartEvent;
import com.atlassian.activeobjects.spi.RestoreProgressMonitor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.restore.RestoreState;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveObjectsRestoreStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(ActiveObjectsRestoreStep.class);
    private final Backup backup;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private volatile Progress progress;
    private final RestoreState state;

    public ActiveObjectsRestoreStep(RestoreState state, EventPublisher eventPublisher, I18nService i18nService, OsgiServiceProxyFactory osgiServiceProxyFactory) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.state = state;
        this.backup = (Backup)osgiServiceProxyFactory.createProxy(Backup.class);
    }

    @Nonnull
    public Progress getProgress() {
        return this.progress != null ? this.progress : new ProgressImpl(this.i18nService.getMessage("stash.backup.restore.activeobjects", new Object[0]), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File backupDir = this.state.getUnzippedBackupDirectory();
        Preconditions.checkState((backupDir != null ? 1 : 0) != 0, (Object)"Unpacked backup not found");
        File activeObjectsFile = new File(backupDir, "active-objects-data.xml");
        log.debug("Restoring ActiveObjects data from {}", (Object)activeObjectsFile.getAbsolutePath());
        try {
            FileInputStream stream = new FileInputStream(activeObjectsFile);
            try {
                this.backup.restore((InputStream)stream, (RestoreProgressMonitor)new RestoreMonitor());
                this.eventPublisher.publish((Object)HotRestartEvent.INSTANCE);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (Exception e) {
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.backup.restore.activeobjects.failed", new Object[]{activeObjectsFile.getAbsolutePath()}), (Throwable)e);
        }
    }

    private class RestoreMonitor
    extends AbstractRestoreProgressMonitor {
        private static final int PROGRESS_SCHEMA = 20;
        private static final int PROGRESS_DATA = 80;
        private int tableCount;
        private int tablesRestored;

        private RestoreMonitor() {
        }

        public void beginTableDefinitionsRestore() {
            ActiveObjectsRestoreStep.this.progress = (Progress)new ProgressImpl(ActiveObjectsRestoreStep.this.i18nService.getMessage("stash.backup.activeobjects.restore.definitions", new Object[0]), 0);
        }

        public void beginTablesRestore() {
            ActiveObjectsRestoreStep.this.progress = (Progress)new ProgressImpl(ActiveObjectsRestoreStep.this.i18nService.getMessage("stash.backup.activeobjects.restore.data", new Object[0]), 20);
        }

        public void endTableDataRestore(String tableName) {
            ActiveObjectsRestoreStep.this.progress = (Progress)new ProgressImpl(ActiveObjectsRestoreStep.this.progress.getMessage(), 20 + 80 * ++this.tablesRestored / this.tableCount);
        }

        public void updateTotalNumberOfTablesToRestore(int tableCount) {
            this.tableCount = tableCount;
        }
    }
}

