/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.config.DataSourcePropertySerializer;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.Flushables;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ConfigurationBackupStep
extends AbstractMaintenanceTask {
    public static final String BANNER = "#> Produced for backup from default configuration";
    public static final String CONFIG_FILE = "stash-config.properties";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBackupStep.class);
    private final File homeDirectory;
    private final I18nService i18nService;
    private volatile int progress;
    private final BackupState state;

    public ConfigurationBackupStep(BackupState state, @Value(value="#{applicationSettings.homeDir}") File homeDirectory, I18nService i18nService) {
        this.homeDirectory = homeDirectory;
        this.i18nService = i18nService;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("stash.backup.configuration", new Object[]{Product.NAME}), this.progress);
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry(CONFIG_FILE);
            stream.putNextEntry(entry);
            log.debug("Backing up {} configuration to {}", (Object)Product.NAME, (Object)CONFIG_FILE);
            this.writeConfigurationBackup((OutputStream)new CloseShieldOutputStream((OutputStream)stream));
            stream.closeEntry();
            this.progress = 100;
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.createKeyedMessage("stash.backup.configuration.failed", new Object[]{Product.NAME}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigurationBackup(OutputStream stream) throws IOException {
        File stashConfig = new File(this.homeDirectory, CONFIG_FILE);
        if (stashConfig.exists()) {
            Files.copy((File)stashConfig, (OutputStream)stream);
        } else {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
            try {
                this.writeDefaultConfiguration(writer);
            }
            finally {
                Flushables.flush((Flushable)writer, (boolean)false);
            }
        }
    }

    private void writeDefaultConfiguration(BufferedWriter writer) throws IOException {
        DataSourcePropertySerializer serializer = new DataSourcePropertySerializer(this.state.getSourceDatabase().getConfiguration());
        writer.write("#> Produced for backup from default configuration\n");
        serializer.writeTo(writer);
    }
}

