/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.backup.BackupCanceledEvent;
import com.atlassian.stash.event.backup.BackupFailedEvent;
import com.atlassian.stash.event.backup.BackupStartedEvent;
import com.atlassian.stash.event.backup.BackupSucceededEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.backup.CanceledBackupException;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.maintenance.TaskMaintenanceEvent;
import com.atlassian.stash.internal.maintenance.backup.BackupClientPlaceholderStep;
import com.atlassian.stash.internal.maintenance.backup.BackupClientProgressCallback;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.internal.maintenance.backup.SimpleBackupState;
import com.atlassian.stash.util.Progress;
import javax.annotation.Nonnull;

public abstract class AbstractBackupTask
implements MaintenanceTask {
    private final BackupClientPlaceholderStep backupClientPlaceholderStep;
    private final DatabaseManager databaseManager;
    private final MaintenanceTask delegateTask;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private volatile boolean canceled;

    public AbstractBackupTask(DatabaseManager databaseManager, EventPublisher eventPublisher, I18nService i18nService, MaintenanceTaskFactory maintenanceTaskFactory) {
        this.backupClientPlaceholderStep = maintenanceTaskFactory.backupClientBackupStep();
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        SimpleBackupState backupState = new SimpleBackupState(databaseManager.getHandle());
        TaskMaintenanceEvent maintenanceEvent = new TaskMaintenanceEvent(EventType.get((String)"performing-maintenance"), Product.NAME + " is unavailable while it is being backed up", EventLevel.get((String)"maintenance"), MaintenanceType.BACKUP);
        this.delegateTask = this.createDelegateBackupTask(maintenanceTaskFactory, backupState, maintenanceEvent, this.backupClientPlaceholderStep);
    }

    protected abstract MaintenanceTask createDelegateBackupTask(MaintenanceTaskFactory var1, BackupState var2, TaskMaintenanceEvent var3, BackupClientPlaceholderStep var4);

    public void cancel() {
        this.canceled = true;
        this.delegateTask.cancel();
    }

    public BackupClientProgressCallback getClientProgressCallback() {
        return this.backupClientPlaceholderStep;
    }

    @Nonnull
    public Progress getProgress() {
        return this.delegateTask.getProgress();
    }

    public void run() {
        try {
            this.eventPublisher.publish((Object)new BackupStartedEvent((Object)this));
            this.delegateTask.run();
            if (this.canceled) {
                throw new CanceledBackupException(this.i18nService.createKeyedMessage("stash.backup.canceled", new Object[0]));
            }
            this.eventPublisher.publish((Object)new BackupSucceededEvent((Object)this));
        }
        catch (Throwable t) {
            this.unlatchDatabase();
            BackupException exception = t instanceof BackupException ? (BackupException)t : new BackupException(this.i18nService.createKeyedMessage("stash.backup.failed", new Object[]{Product.NAME}), t);
            if (exception instanceof CanceledBackupException) {
                this.eventPublisher.publish((Object)new BackupCanceledEvent((Object)this));
            } else {
                this.eventPublisher.publish((Object)new BackupFailedEvent((Object)this));
            }
            throw exception;
        }
    }

    private void unlatchDatabase() {
        DatabaseLatch latch = this.databaseManager.getCurrentLatch();
        if (latch != null) {
            latch.unlatch();
        }
    }
}

