/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.RemoveEvent;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.stash.internal.maintenance.CompositeMaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceEvent;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceModePhase
extends CompositeMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceModePhase.class);
    private final EventPublisher eventPublisher;
    private final MaintenanceEvent maintenanceEvent;
    private final LifecycleAwareSchedulerService schedulerService;

    private MaintenanceModePhase(CompositeMaintenanceTask.Step[] steps, int totalWeight, EventPublisher eventPublisher, LifecycleAwareSchedulerService schedulerService, MaintenanceEvent maintenanceEvent) {
        super(steps, totalWeight);
        this.eventPublisher = eventPublisher;
        this.maintenanceEvent = maintenanceEvent;
        this.schedulerService = schedulerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.schedulerService != null) {
            this.pauseScheduler();
        }
        try {
            this.eventPublisher.publish((Object)new AddEvent((Object)this, (Event)this.maintenanceEvent));
            try {
                super.run();
            }
            finally {
                this.eventPublisher.publish((Object)new RemoveEvent((Object)this, (Event)this.maintenanceEvent));
            }
        }
        finally {
            if (this.schedulerService != null) {
                this.resumeScheduler();
            }
        }
    }

    private void pauseScheduler() {
        try {
            this.schedulerService.pause();
        }
        catch (SchedulerServiceException e) {
            log.warn("The Scheduler threw an exception when it was paused. This usually means the Scheduler has already been shutdown.", (Throwable)e);
        }
    }

    private void resumeScheduler() {
        try {
            this.schedulerService.resume();
        }
        catch (SchedulerServiceException e) {
            log.warn("The Scheduler threw an exception when it was resumed. This usually means some jobs missed their configured start time because the scheduler was paused.", (Throwable)e);
        }
    }

    public static class Builder
    extends CompositeMaintenanceTask.AbstractBuilder<Builder> {
        private final EventPublisher eventPublisher;
        private MaintenanceEvent maintenanceEvent;
        private final LifecycleAwareSchedulerService schedulerService;

        public Builder(EventPublisher eventPublisher, LifecycleAwareSchedulerService schedulerService) {
            this.eventPublisher = eventPublisher;
            this.schedulerService = schedulerService;
        }

        public Builder event(MaintenanceEvent event) {
            this.maintenanceEvent = event;
            return this;
        }

        @Override
        @Nonnull
        public MaintenanceModePhase build() {
            return new MaintenanceModePhase(this.steps.toArray(new CompositeMaintenanceTask.Step[this.steps.size()]), this.totalWeight, this.eventPublisher, this.schedulerService, this.maintenanceEvent);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

