/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.i18n.I18nKey;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.locale.LocaleUtils;
import com.atlassian.stash.internal.user.InternalUserLocaleService;
import com.atlassian.stash.mail.HtmlCssInliner;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.mail.SoyMailBuilder;
import com.atlassian.stash.mail.SoyMailMessageRequest;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.PredicateUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=SoyMailBuilder.class)
@Component
public class SoyMailBuilderImpl
implements SoyMailBuilder {
    private static final Logger log = LoggerFactory.getLogger(SoyMailBuilderImpl.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final HtmlCssInliner htmlCssInliner;
    private final I18nService i18nService;
    private final SecurityService securityService;
    private final InternalUserLocaleService userLocaleService;

    @Autowired
    public SoyMailBuilderImpl(SoyTemplateRenderer soyTemplateRenderer, HtmlCssInliner htmlCssInliner, I18nService i18nService, SecurityService securityService, InternalUserLocaleService userLocaleService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.htmlCssInliner = htmlCssInliner;
        this.i18nService = i18nService;
        this.securityService = securityService;
        this.userLocaleService = userLocaleService;
    }

    public Iterable<MailMessage> build(@NotNull Iterable<StashUser> recipients, @NotNull String subject, @NotNull String soyTemplateModuleName, @NotNull String soyTemplateName, @NotNull String cssModuleName, @NotNull Map<String, Object> context, @Nullable Function<MailMessage.Builder, MailMessage.Builder> messageEffector) {
        return this.build(new SoyMailMessageRequest.Builder().cssModuleKey(cssModuleName).context(context).messageEffector(messageEffector).recipients(recipients).soyTemplateModuleKey(soyTemplateModuleName).soyTemplateName(soyTemplateName).subject(subject).build());
    }

    public Iterable<MailMessage> build(final @NotNull SoyMailMessageRequest message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        return (Iterable)LocaleUtils.withLocale(null, (Operation)new UncheckedOperation<Iterable<MailMessage>>(){

            public Iterable<MailMessage> perform() {
                return SoyMailBuilderImpl.this.buildWithNoLocale(message);
            }
        });
    }

    private Iterable<MailMessage> buildWithNoLocale(SoyMailMessageRequest message) {
        HashSet<MailMessage> messages = new HashSet<MailMessage>();
        HashMap localeToMessage = Maps.newHashMap();
        for (StashUser user : Chainable.chain((Iterable)message.getRecipients()).filter(Predicates.compose((Predicate)PredicateUtils.notBlank(), (Function)StashUser.TO_EMAIL_ADDRESS))) {
            Option localeKey = Option.option((Object)this.userLocaleService.getLocale(user));
            Option<LocalizedMessage> cachedMessage = (Option<LocalizedMessage>)localeToMessage.get(localeKey);
            if (cachedMessage == null) {
                cachedMessage = this.getLocalizedMessage(user, message, (Option<Locale>)localeKey);
                localeToMessage.put(localeKey, cachedMessage);
            }
            for (LocalizedMessage localizedMessage : cachedMessage) {
                MailMessage.Builder mailMessageBuilder = new MailMessage.Builder().to(new String[]{user.getEmailAddress()}).text(localizedMessage.text).subject(localizedMessage.subject).header("Content-Type", "text/html; charset=UTF-8");
                for (Locale locale : localizedMessage.locale) {
                    mailMessageBuilder.header("Content-Language", locale.toLanguageTag());
                }
                mailMessageBuilder = (MailMessage.Builder)message.getMessageEffector().apply((Object)mailMessageBuilder);
                messages.add(mailMessageBuilder.build());
            }
        }
        return messages;
    }

    private Option<LocalizedMessage> getLocalizedMessage(StashUser user, final SoyMailMessageRequest message, final Option<Locale> locale) {
        return (Option)this.securityService.impersonating(user, "Impersonate user for sending mail").call((Operation)new UncheckedOperation<Option<LocalizedMessage>>(){

            public Option<LocalizedMessage> perform() {
                try {
                    String subjectText = message.getSubject();
                    if (message.getSubjectKey() != null) {
                        I18nKey subjectKey = message.getSubjectKey();
                        subjectText = SoyMailBuilderImpl.this.i18nService.getMessage(subjectKey);
                    }
                    String text = SoyMailBuilderImpl.this.htmlCssInliner.inlineCss(SoyMailBuilderImpl.this.soyTemplateRenderer.render(message.getSoyTemplateModuleKey(), message.getSoyTemplateName(), message.getContext()), message.getCssModuleKey());
                    return Option.some((Object)new LocalizedMessage(locale, subjectText, text));
                }
                catch (SoyException e) {
                    log.error("Error rendering email notification ({}/{})", new Object[]{message.getSoyTemplateModuleKey(), message.getSoyTemplateName(), e});
                    return Option.none();
                }
            }
        });
    }

    private static class LocalizedMessage {
        private final Option<Locale> locale;
        private final String subject;
        private final String text;

        private LocalizedMessage(Option<Locale> locale, String subject, String text) {
            this.locale = locale;
            this.subject = subject;
            this.text = text;
        }
    }
}

