/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.botocss.BotocssStyles;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.mail.BotocssStylesResolver;
import com.atlassian.stash.internal.plugin.SimpleServletContextFactory;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component(value="botocssStylesResolver")
@Profiled
public class BotocssStylesResolverImpl
implements BotocssStylesResolver {
    private static final String BOTOCSS_STYLES_CACHE = "com.atlassian.stash.internal.mail.BotocssStylesResolver";
    private static final Logger log = LoggerFactory.getLogger(BotocssStylesResolver.class);
    private final SimpleServletContextFactory servletContextFactory;
    private final CacheManager cacheManager;
    private final ResourceDependencyResolver resourceResolver;

    @Autowired
    public BotocssStylesResolverImpl(ResourceDependencyResolver resourceResolver, SimpleServletContextFactory servletContextFactory, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.resourceResolver = resourceResolver;
        this.servletContextFactory = servletContextFactory;
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.clearCache();
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.clearCache();
    }

    private void clearCache() {
        this.cacheManager.getCache(BOTOCSS_STYLES_CACHE).clear();
    }

    @Cacheable(value={"com.atlassian.stash.internal.mail.BotocssStylesResolver"})
    public BotocssStyles getBotocssStylesForModuleKey(String moduleKey) {
        Iterable<InputStream> css = this.getStylesForModuleKey(moduleKey);
        try {
            return BotocssStyles.parse((String[])new String[]{IOUtils.toString((InputStream)new SequenceInputStream(Iterators.asEnumeration(css.iterator())))});
        }
        catch (IOException e) {
            log.debug("IOException when attempting to convert CSS to String", (Throwable)e);
            return BotocssStyles.parse((String[])new String[0]);
        }
    }

    private Iterable<InputStream> getStylesForModuleKey(String moduleKey) {
        return Chainable.chain((Iterable)this.resourceResolver.getDependencies(moduleKey, false)).flatMap((Function)new Function<WebResourceModuleDescriptor, Iterable<InputStream>>(){

            public Iterable<InputStream> apply(@Nullable WebResourceModuleDescriptor moduleDescriptor) {
                return BotocssStylesResolverImpl.this.getStylesForModuleDescriptor(moduleDescriptor);
            }
        });
    }

    private Iterable<InputStream> getStylesForModuleDescriptor(final WebResourceModuleDescriptor moduleDescriptor) {
        Predicate<ResourceDescriptor> cssResourcePredicate = new Predicate<ResourceDescriptor>(){

            public boolean apply(@Nullable ResourceDescriptor rd) {
                return rd != null && rd.getLocation().endsWith(".css");
            }
        };
        Function<ResourceDescriptor, InputStream> inputStreamForResourceDescriptor = new Function<ResourceDescriptor, InputStream>(){

            public InputStream apply(ResourceDescriptor rd) {
                return BotocssStylesResolverImpl.this.getResourceStreamViaMinificationStrategy(moduleDescriptor.getPlugin(), rd);
            }
        };
        return Chainable.chain((Iterable)moduleDescriptor.getResourceDescriptors()).filter((Predicate)cssResourcePredicate).transform((Function)inputStreamForResourceDescriptor).filter(Predicates.notNull());
    }

    private InputStream getResourceStreamViaMinificationStrategy(Plugin plugin, ResourceDescriptor resourceDescriptor) {
        String resourceLocation = resourceDescriptor.getLocation();
        InputStream resourceAsStream = this.getResourceAsStream(plugin, resourceDescriptor, this.minifiedLocationIfAvailable(resourceLocation));
        if (resourceAsStream != null) {
            return resourceAsStream;
        }
        return this.getResourceAsStream(plugin, resourceDescriptor, resourceLocation);
    }

    private InputStream getResourceAsStream(Plugin plugin, ResourceDescriptor resourceDescriptor, String resourceLocation) {
        String sourceParam = resourceDescriptor.getParameter("source");
        if ("webContextStatic".equalsIgnoreCase(sourceParam)) {
            return this.servletContextFactory.getServletContext().getResourceAsStream(resourceLocation);
        }
        return plugin.getResourceAsStream(resourceLocation);
    }

    private String minifiedLocationIfAvailable(String resourceLocation) {
        if (Boolean.getBoolean("atlassian.dev.mode") || resourceLocation.endsWith("-min.css") || resourceLocation.endsWith(".min.css")) {
            return resourceLocation;
        }
        return this.getMinifiedLocation(resourceLocation);
    }

    private String getMinifiedLocation(String location) {
        int lastDot = location.lastIndexOf(".");
        return location.substring(0, lastDot) + "-min" + location.substring(lastDot);
    }
}

