/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.config.log.LoggingService;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.config.log.InternalLoggingService;
import com.atlassian.stash.internal.log.EnhancedLevel;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=LoggingService.class)
@Service(value="loggingService")
public class LogbackLoggingService
implements InternalLoggingService,
StatefulService {
    private static final Map<String, Level> DEBUG_PROFILE_LOG_LEVELS = ImmutableMap.builder().put((Object)"ROOT", (Object)Level.INFO).put((Object)"com.atlassian.stash", (Object)Level.DEBUG).put((Object)"org.hibernate", (Object)Level.INFO).put((Object)"org.springframework", (Object)Level.INFO).put((Object)"net.sf.ehcache", (Object)Level.INFO).build();
    public static final String GENERIC_PROPERTY_PREFIX = "logging.logger.";
    public static final String LOG4J_PROPERTY_PREFIX = "log4j.logger.";
    public static final Set<String> PROPERTY_PREFIXES = ImmutableSet.of((Object)"log4j.logger.", (Object)"logging.logger.");
    private final Map<String, String> standardProfileLogLevels = Maps.newHashMap();
    private final ApplicationPropertiesService propertiesService;
    private final I18nService i18nService;
    private final Properties properties;

    @Autowired
    public LogbackLoggingService(I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties, ApplicationPropertiesService applicationPropertiesService) {
        this.i18nService = i18nService;
        this.properties = properties;
        this.propertiesService = applicationPropertiesService;
    }

    @PostConstruct
    public void applyLevelProperties() {
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            for (String prefix : PROPERTY_PREFIXES) {
                String levelName;
                if (!propertyName.startsWith(prefix) || (levelName = StringUtils.trimToNull((String)this.properties.getProperty(propertyName))) == null) continue;
                String loggerName = propertyName.substring(prefix.length());
                this.setLevel(loggerName, levelName);
            }
        }
        if (this.propertiesService.isDebugLoggingEnabled()) {
            this.enableDebugLogging();
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void disableDebugLogging() {
        for (String loggerName : DEBUG_PROFILE_LOG_LEVELS.keySet()) {
            String originalLevel = this.standardProfileLogLevels.remove(loggerName);
            if (originalLevel == null) continue;
            this.setLevel(loggerName, originalLevel);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void enableDebugLogging() {
        for (Map.Entry<String, Level> entry : DEBUG_PROFILE_LOG_LEVELS.entrySet()) {
            String loggerName = entry.getKey();
            Level currentLevel = this.getLogbackLevel(loggerName);
            Level desiredLevel = entry.getValue();
            if (desiredLevel.isGreaterOrEqual(currentLevel)) continue;
            this.standardProfileLogLevels.put(loggerName, currentLevel.levelStr);
            this.setLevel(loggerName, desiredLevel.levelStr);
        }
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new MdcState(MDC.getCopyOfContextMap());
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public String getLevel(String loggerName) {
        ch.qos.logback.classic.Logger logger = this.getLogger(loggerName);
        Level effectiveLevel = logger.getEffectiveLevel();
        return effectiveLevel.levelStr;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public String getRootLevel() {
        return this.getLevel("ROOT");
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setLevel(String loggerName, String levelName) {
        Level level = this.toLevel(levelName);
        String name = StringUtils.trimToNull((String)loggerName);
        if (name == null) {
            String message = this.i18nService.getMessage("stash.logging.logger.name.required", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        ch.qos.logback.classic.Logger logger = this.getLogger(name);
        Level effectiveLevel = logger.getEffectiveLevel();
        if (effectiveLevel != level) {
            EnhancedLevel.fromLevel(effectiveLevel).log((Logger)logger, "Switching to log level [{}]", levelName);
            logger.setLevel(level);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setRootLevel(String levelName) {
        this.setLevel("ROOT", levelName);
    }

    private ch.qos.logback.classic.Logger getLogger(String name) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        return lc.getLogger(name);
    }

    private Level getLogbackLevel(String loggerName) {
        return this.getLogger(loggerName).getEffectiveLevel();
    }

    private Level toLevel(String levelName) {
        Level level = Level.toLevel((String)levelName, null);
        if (level == null) {
            String message = this.i18nService.getMessage("stash.logging.level.invalid", new Object[]{levelName});
            throw new IllegalArgumentException(message);
        }
        return level;
    }

    private static final class MdcState
    implements TransferableState {
        private final Map<?, ?> state;

        private MdcState(Map<?, ?> state) {
            this.state = state;
        }

        public void apply() {
            if (this.state != null) {
                MDC.setContextMap(this.state);
            }
        }

        public void remove() {
            MDC.clear();
        }
    }
}

