/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.commit.CommitEnricher;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.idx.IndexSearchRequest;
import com.atlassian.stash.idx.IndexedChangeset;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.content.IndexedChangesetDao;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=ChangesetIndex.class)
@Component(value="changesetIndex")
@Transactional(readOnly=true)
public class DbChangesetIndex
implements ChangesetIndex {
    private final Predicate<Repository> canReadRepositoryPredicate;
    private final IndexedChangesetDao changesetDao;
    @Autowired
    private CommitEnricher commitEnricher;
    @Value(value="${page.max.index.results}")
    private int maxIndexResults;

    @Autowired
    public DbChangesetIndex(IndexedChangesetDao changesetDao, PermissionPredicateFactory predicateFactory) {
        this.canReadRepositoryPredicate = predicateFactory.createRepositoryAccessiblePredicate();
        this.changesetDao = changesetDao;
    }

    @Transactional
    public void addAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)name, (Object)"attributeName");
        Preconditions.checkNotNull((Object)value, (Object)"attributeValue");
        this.changesetDao.addAttribute((InternalIndexedChangeset)this.changesetDao.getById((Object)csid), name, value);
    }

    @Transactional
    public void addChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)changeset, (Object)"changeset");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        InternalIndexedChangeset cs = (InternalIndexedChangeset)this.changesetDao.getById((Object)changeset.getId());
        if (cs == null) {
            cs = new InternalIndexedChangeset(changeset.getId(), changeset.getAuthorTimestamp());
            this.changesetDao.create((Object)cs);
        }
        if (!DbChangesetIndex.isPersonalFork(repository)) {
            this.changesetDao.addMembership(cs, InternalConverter.convertToInternalRepository((Repository)repository));
        }
    }

    @Nonnull
    public Changeset enrichChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository, Collection<String> attributeNames) {
        return this.commitEnricher.enrich(repository, changeset, attributeNames);
    }

    @Nonnull
    public Page<Changeset> enrichChangesets(@Nonnull Page<Changeset> changesets, @Nonnull Repository repository, Collection<String> attributeNames) {
        return this.commitEnricher.enrich(repository, changesets, attributeNames);
    }

    @Nonnull
    public Page<IndexedChangeset> findChangesetsByAttribute(@Nonnull String attributeName, @Nonnull String attributeValue, boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        Preconditions.checkNotNull((Object)attributeValue, (Object)"attributeValue");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxIndexResults);
        List changesets = this.changesetDao.findByAttribute(attributeName, attributeValue, caseSensitive);
        ArrayList<IndexedChangeset> result = new ArrayList<IndexedChangeset>();
        Iterator it = changesets.iterator();
        int pageEndIndex = pageRequest.getStart() + pageRequest.getLimit();
        int index = 0;
        while (index <= pageEndIndex && it.hasNext()) {
            IndexedChangeset changeset = this.transformForPermissions((InternalIndexedChangeset)it.next());
            if (changeset.getRepositories().isEmpty()) continue;
            if (index >= pageRequest.getStart()) {
                result.add(changeset);
            }
            ++index;
        }
        return PageUtils.createPage(result, (PageRequest)pageRequest);
    }

    @Nonnull
    public AttributeMap getAttributeValues(@Nonnull String csid, @Nonnull Collection<String> attributeNames) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull(attributeNames, (Object)"attributeNames");
        return this.changesetDao.getAttributesForChangeset(csid, attributeNames);
    }

    @Nonnull
    public Map<String, AttributeMap> getAttributeValues(@Nonnull Collection<String> csids, @Nonnull Collection<String> attributeNames) {
        Preconditions.checkNotNull(csids, (Object)"changesetIds");
        Preconditions.checkNotNull(attributeNames, (Object)"attributeNames");
        return this.changesetDao.getAttributesForChangesets(csids, attributeNames);
    }

    public IndexedChangeset getChangeset(@Nonnull String csid) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        IndexedChangeset cs = (IndexedChangeset)this.changesetDao.getById((Object)csid);
        if (cs != null && Iterables.any((Iterable)cs.getRepositories(), this.canReadRepositoryPredicate)) {
            return cs;
        }
        return null;
    }

    public boolean isMemberOf(@Nonnull String changesetId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)changesetId, (Object)"changesetId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return this.canReadRepositoryPredicate.apply((Object)repository) && this.changesetDao.isMemberOf(changesetId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Transactional
    public void removeAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)name, (Object)"attributeName");
        Preconditions.checkNotNull((Object)value, (Object)"attributeValue");
        this.changesetDao.removeAttribute(csid, name, value);
    }

    @Transactional
    public void removeChangeset(@Nonnull String csid, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.changesetDao.deleteMembership(csid, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Nonnull
    public Page<IndexedChangeset> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)searchRequest, (Object)"searchRequest");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return PageUtils.asPageOf(IndexedChangeset.class, (Page)this.changesetDao.search(searchRequest, pageRequest));
    }

    private static boolean isPersonalFork(Repository repository) {
        return repository.isFork() && repository.getProject().getType() == ProjectType.PERSONAL;
    }

    private IndexedChangeset transformForPermissions(final InternalIndexedChangeset changeset) {
        final Set repositories = Chainable.chain((Iterable)changeset.getRepositories()).filter(this.canReadRepositoryPredicate).toSet();
        return new IndexedChangeset(){

            @Nonnull
            public String getId() {
                return changeset.getId();
            }

            @Nonnull
            public Date getAuthorTimestamp() {
                return changeset.getAuthorTimestamp();
            }

            @Nonnull
            public Set<Repository> getRepositories() {
                return repositories;
            }
        };
    }
}

