/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n.cache;

import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MessageMapIndex<K, V> {
    private final ImmutableMap<K, ImmutableSet<MessageKey>> index;
    private final MessageMap<V> messages;

    MessageMapIndex() {
        this(ImmutableMap.of(), new MessageMap());
    }

    MessageMapIndex(ImmutableMap<K, ImmutableSet<MessageKey>> index, MessageMap<V> messages) {
        this.index = index;
        this.messages = messages;
    }

    @Nonnull
    public MessageMapIndex<K, V> add(@Nonnull K key, @Nonnull MessageMap<V> newMessages) {
        HashMap map = Maps.newHashMap(this.index);
        map.put(key, newMessages.keySet());
        return new MessageMapIndex<K, V>(ImmutableMap.copyOf((Map)map), this.messages.append(newMessages));
    }

    @Nonnull
    public MessageMap<V> getMessages() {
        return this.messages;
    }

    @Nonnull
    public MessageMapIndex<K, V> remove(@Nonnull K key) {
        ImmutableSet keys = (ImmutableSet)this.index.get(key);
        return keys == null ? this : new MessageMapIndex<K, V>(ImmutableMap.copyOf((Map)Maps.filterKeys(this.index, (Predicate)Predicates.not((Predicate)Predicates.equalTo(key)))), this.messages.remove((Collection<MessageKey>)keys));
    }
}

