/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n.cache;

import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.LocaleUtils;

@ThreadSafe
public class MessageMap<T> {
    private final ImmutableMap<MessageKey, T> messages;

    public MessageMap() {
        this(ImmutableMap.of());
    }

    private MessageMap(ImmutableMap<MessageKey, T> messages) {
        this.messages = messages;
    }

    @Nonnull
    public MessageMap<T> append(@Nonnull MessageMap<T> other) {
        Builder<T> map = new Builder<T>(this.messages);
        map.putAll((Map<MessageKey, T>)other.messages);
        return map.build();
    }

    @Nullable
    public T get(@Nonnull String key, @Nonnull Iterable<Locale> locales) {
        for (Locale locale : locales) {
            for (Locale subLocale : LocaleUtils.localeLookupList((Locale)locale)) {
                Object text = this.messages.get((Object)new MessageKey(key, subLocale));
                if (text == null) continue;
                return (T)text;
            }
        }
        return null;
    }

    @Nonnull
    public ImmutableSet<MessageKey> keySet() {
        return this.messages.keySet();
    }

    @Nonnull
    public MessageMap<T> remove(@Nonnull Collection<MessageKey> keys) {
        return new Builder<T>(this.messages).removeAll(keys).build();
    }

    public String toString() {
        return String.format("[messages=%s]", this.messages);
    }

    public static class Builder<T> {
        private final Map<MessageKey, T> map;

        public Builder() {
            this.map = Maps.newHashMap();
        }

        public Builder(Map<MessageKey, T> value) {
            this.map = Maps.newHashMap(value);
        }

        public MessageMap<T> build() {
            return new MessageMap(ImmutableMap.copyOf(this.map));
        }

        public Builder<T> put(MessageKey key, T value) {
            this.map.put(key, value);
            return this;
        }

        public Builder<T> putAll(Map<MessageKey, T> value) {
            this.map.putAll(value);
            return this;
        }

        public Builder<T> removeAll(Collection<MessageKey> keys) {
            for (MessageKey key : keys) {
                this.map.remove(key);
            }
            return this;
        }
    }
}

