/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n.cache;

import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.atlassian.stash.internal.i18n.cache.MessageMapIndex;
import com.atlassian.util.concurrent.atomic.AtomicReference;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MessageCache<K, V> {
    private final AtomicReference<MessageMapIndex<K, V>> messagesRef = new AtomicReference(new MessageMapIndex());

    @Nonnull
    public MessageMap<V> getMessages() {
        return ((MessageMapIndex)this.messagesRef.get()).getMessages();
    }

    @Nonnull
    public MessageMap<V> put(final @Nonnull K key, final @Nonnull MessageMap<V> messages) {
        MessageMap<V> previous = this.getMessages();
        this.messagesRef.update(new Function<MessageMapIndex<K, V>, MessageMapIndex<K, V>>(){

            public MessageMapIndex<K, V> apply(MessageMapIndex<K, V> state) {
                return state.add(key, messages);
            }
        });
        return previous;
    }

    public void remove(final @Nonnull K key) {
        this.messagesRef.update(new Function<MessageMapIndex<K, V>, MessageMapIndex<K, V>>(){

            public MessageMapIndex<K, V> apply(MessageMapIndex<K, V> state) {
                return state.remove(key);
            }
        });
    }
}

