/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.i18n.I18nKey;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.i18n.I18nClasspathScanner;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.i18n.cache.MessageCache;
import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class PluginI18nService
implements ApplicationListener<ContextRefreshedEvent>,
I18nService {
    private static final Logger log = LoggerFactory.getLogger(PluginI18nService.class);
    private static final Locale defaultLocale = Locale.ENGLISH;
    private final LocaleHolder localeHolder;
    private final MessageCache<String, String> messageCache;
    private volatile I18nClasspathScanner classpathScanner;

    public PluginI18nService(LocaleHolder localeHolder) {
        this(new MessageCache<String, String>(), localeHolder);
    }

    @VisibleForTesting
    PluginI18nService(MessageCache<String, String> messageCache, LocaleHolder localeHolder) {
        this.messageCache = messageCache;
        this.localeHolder = localeHolder;
    }

    @Nonnull
    public KeyedMessage createKeyedMessage(@Nonnull String key, Object ... arguments) {
        return this.getKeyedText(key, null, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull String key, Object ... arguments) {
        return this.getText(key, null, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull I18nKey key) {
        return this.getText(key.getKey(), null, key.getArguments());
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix) {
        return this.getAllTranslationsForPrefix(prefix, this.localeHolder.getLocales(new Locale[0]));
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix, @Nonnull Locale locale) {
        return this.getAllTranslationsForPrefix(prefix, this.localeHolder.getLocales(new Locale[]{locale}));
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        return new KeyedMessage(key, this.getText(key, fallbackMessage, arguments), this.getText(defaultLocale, key, fallbackMessage, arguments));
    }

    public KeyedMessage getKeyedText(@Nonnull I18nKey i18nKey) {
        return this.createKeyedMessage(i18nKey.getKey(), i18nKey.getArguments());
    }

    public String getMessagePattern(@Nonnull String key) {
        return this.getMessagePattern(key, null);
    }

    public String getMessagePattern(@Nonnull String key, String fallbackPattern) {
        return this.getMessagePattern(this.localeHolder.getLocales(new Locale[0]), key, fallbackPattern);
    }

    @Nonnull
    public String getText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.getText(this.localeHolder.getLocales(new Locale[0]), key, fallbackMessage, arguments);
    }

    @Nonnull
    public String getText(@Nonnull Locale locale, @Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.getText(this.localeHolder.getLocales(new Locale[]{locale}), key, fallbackMessage, arguments);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.classpathScanner == null) {
            this.classpathScanner = (I18nClasspathScanner)event.getApplicationContext().getBean(I18nClasspathScanner.class);
        }
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        log.debug("Removing plugin {}", (Object)event.getPlugin().getName());
        this.messageCache.remove(event.getPlugin().getKey());
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            log.debug("Adding plugin {}", (Object)event.getPlugin().getName());
            MessageMap<String> newMessages = this.classpathScanner.scanForMessages(event.getPlugin(), defaultLocale);
            MessageMap<String> previousMessages = this.messageCache.put(event.getPlugin().getKey(), newMessages);
            Sets.SetView removedKeys = Sets.intersection(newMessages.keySet(), previousMessages.keySet());
            if (!removedKeys.isEmpty()) {
                log.debug("Attempting to insert duplicate i18n keys {} from plugin {}", (Object)removedKeys, (Object)event.getPlugin().getKey());
            }
        }
        catch (Exception e) {
            log.error("Error loading i18n properties from plugin {}", (Object)event.getPlugin().getName(), (Object)e);
        }
    }

    private Map<String, String> getAllTranslationsForPrefix(String prefix, Iterable<Locale> locales) {
        HashMap translations = Maps.newHashMap();
        MessageMap<String> messages = this.messageCache.getMessages();
        Set keys = Chainable.chain(messages.keySet()).transform(MessageKey.TO_KEY).filter(PredicateUtils.startsWith((String)prefix)).toSet();
        for (String key : keys) {
            String messageText = messages.get(key, locales);
            if (messageText == null) continue;
            translations.put(key, messageText);
        }
        return translations;
    }

    private String getMessagePattern(Iterable<Locale> locales, String key, String fallbackPattern) {
        String messagePattern = this.messageCache.getMessages().get(key, locales);
        if (messagePattern == null) {
            log.debug("No values found in any valid locale for key {} and locales {}", (Object)key, locales);
        }
        return messagePattern == null ? fallbackPattern : messagePattern;
    }

    private String getText(@Nonnull Iterable<Locale> locales, @Nonnull String key, String fallbackMessage, Object ... arguments) {
        String messagePattern = this.getMessagePattern((Iterable)Preconditions.checkNotNull(locales, (Object)"locales"), (String)Preconditions.checkNotNull((Object)key, (Object)"key"), fallbackMessage);
        String message = messagePattern != null ? MessageFormat.format(messagePattern, (Object[])Preconditions.checkNotNull((Object)arguments, (Object)"arguments")) : null;
        return message == null ? PluginI18nService.formatFallbackMessage(key, fallbackMessage, arguments) : message;
    }

    private static String formatFallbackMessage(String key, String fallbackMessage, Object[] arguments) {
        String message;
        if (fallbackMessage == null) {
            String string = message = key == null ? "(null)" : key;
            if (arguments != null && arguments.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(message);
                sb.append("[");
                String sep = "";
                for (Object argument : arguments) {
                    sb.append(sep);
                    sb.append(argument == null ? "(null)" : argument.toString());
                    sep = ", ";
                }
                sb.append("]");
                message = sb.toString();
            }
        } else {
            message = MessageFormat.format(fallbackMessage, arguments);
        }
        return message;
    }
}

