/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.atlassian.stash.internal.plugin.PluginPathScanner;
import com.atlassian.stash.internal.plugin.PluginPathScannerFactory;
import com.atlassian.stash.util.Chainable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class I18nClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(I18nClasspathScanner.class);
    private final PluginPathScannerFactory pluginPathScannerFactory;

    @Autowired
    public I18nClasspathScanner(PluginPathScannerFactory pluginPathScannerFactory) {
        this.pluginPathScannerFactory = pluginPathScannerFactory;
    }

    public MessageMap<String> scanForMessages(Plugin plugin, Locale defaultLocale) throws IOException {
        List<String> i18nResources = I18nClasspathScanner.getI18nResources(plugin);
        if (i18nResources.isEmpty()) {
            log.debug("Skipping adding plugin {} - no i18n resources", (Object)plugin.getName());
            return new MessageMap<String>();
        }
        log.debug("Adding plugin {} with {}", (Object)plugin.getName(), i18nResources);
        return I18nClasspathScanner.loadProperties(plugin, defaultLocale, I18nClasspathScanner.scanForI18nResources(this.pluginPathScannerFactory.forPlugin(plugin), i18nResources));
    }

    @VisibleForTesting
    static MessageMap<String> loadProperties(Plugin plugin, Locale defaultLocale, Iterable<Pair<String, Option<Locale>>> files) throws IOException {
        MessageMap.Builder<String> messages = new MessageMap.Builder<String>();
        for (Pair<String, Option<Locale>> pair : files) {
            log.trace("Got {} with locale {}", pair.left(), pair.right());
            Properties properties = new Properties();
            String path = ((String)pair.left()).startsWith("/") ? ((String)pair.left()).substring(1) : (String)pair.left();
            try (InputStream in = plugin.getResourceAsStream(path);){
                properties.load(in);
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                MessageKey key = new MessageKey(e.getKey().toString(), (Locale)((Option)pair.right()).getOrElse((Object)defaultLocale));
                messages.put(key, e.getValue().toString());
            }
        }
        return messages.build();
    }

    @VisibleForTesting
    static Iterable<Pair<String, Option<Locale>>> scanForI18nResources(PluginPathScanner pluginPathScanner, Collection<String> i18nResources) {
        ImmutableListMultimap dirsAndPaths = Multimaps.index(i18nResources, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path.contains(".") ? path.substring(0, path.lastIndexOf(46)).replace('.', '/') + "/" : "";
            }
        });
        ArrayList i18nFiles = Lists.newArrayList();
        for (Map.Entry dirEntry : dirsAndPaths.asMap().entrySet()) {
            block1: for (String file : pluginPathScanner.getPaths("/" + (String)dirEntry.getKey())) {
                for (String classpath : (Collection)dirEntry.getValue()) {
                    Option<Locale> locale = I18nClasspathScanner.getLocale(classpath.replace('.', '/'), file.substring(1));
                    if (locale == null) continue;
                    i18nFiles.add(Pair.pair((Object)file, locale));
                    continue block1;
                }
            }
        }
        return i18nFiles;
    }

    private static List<String> getI18nResources(Plugin plugin) {
        return Chainable.chain((Iterable)plugin.getResourceDescriptors()).filter((Predicate)new Resources.TypeFilter("i18n")).transform((Function)new Function<ResourceDescriptor, String>(){

            public String apply(ResourceDescriptor input) {
                return input.getLocation();
            }
        }).toList();
    }

    private static Option<Locale> getLocale(String resource, String path) {
        if (path.startsWith(resource)) {
            char separator = path.charAt(resource.length());
            if (separator == '.') {
                return Option.none();
            }
            if (separator == '_') {
                String locale = path.substring(resource.length() + 1, path.lastIndexOf(46));
                try {
                    return Option.some((Object)LocaleUtils.toLocale((String)locale));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Error in locale for {} file", (Object)path, (Object)e);
                }
            }
        }
        return null;
    }
}

