/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.InternalUserLocaleService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.LocaleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="localeHolder")
public class DefaultLocaleHolder
implements LocaleHolder {
    private final StashAuthenticationContext authenticationContext;
    private final InternalUserLocaleService userLocaleService;
    private final InternalApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultLocaleHolder(StashAuthenticationContext authenticationContext, InternalApplicationPropertiesService propertiesService, InternalUserLocaleService userLocaleService) {
        this.authenticationContext = authenticationContext;
        this.userLocaleService = userLocaleService;
        this.propertiesService = propertiesService;
    }

    @Nonnull
    public Iterable<Locale> getLocales(Locale ... overrides) {
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        return new LocaleBuilder().addAll(Arrays.asList(overrides)).add(this.userLocaleService.getLocale(this.authenticationContext.getCurrentUser())).add(localeContext != null ? localeContext.getLocale() : null).add(this.propertiesService.getLocale()).add(Locale.ENGLISH).build();
    }

    private static class LocaleBuilder {
        private final List<Locale> locales = Lists.newArrayList();

        private LocaleBuilder() {
        }

        public LocaleBuilder add(Locale locale) {
            if (locale != null && !this.isDuplicate(locale)) {
                this.locales.add(locale);
            }
            return this;
        }

        public LocaleBuilder addAll(Iterable<Locale> locales) {
            for (Locale locale : locales) {
                this.add(locale);
            }
            return this;
        }

        public List<Locale> build() {
            return this.locales;
        }

        private boolean isDuplicate(Locale locale) {
            for (Locale fullLocale : this.locales) {
                for (Locale subLocale : LocaleUtils.localeLookupList((Locale)fullLocale)) {
                    if (!subLocale.equals(locale)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

