/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.hook.BuiltinHookHandlerFactory;
import com.atlassian.stash.hook.HookHandler;
import com.atlassian.stash.hook.HookRequest;
import com.atlassian.stash.hook.HookResponse;
import com.atlassian.stash.hook.PostReceiveHook;
import com.atlassian.stash.hook.PreReceiveHook;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=BuiltinHookHandlerFactory.class)
@Component(value="builtinHookCallbackFactory")
class DefaultBuiltInHookHandlerFactory
implements BuiltinHookHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultBuiltInHookHandlerFactory.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public DefaultBuiltInHookHandlerFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public HookHandler preReceive(final @Nonnull Repository repository, final @Nonnull Collection<RefChange> refChanges) {
        return new HookHandler(){

            /*
             * Loose catch block
             */
            public boolean handle(HookRequest request, HookResponse response) {
                try (Timer loopTimer = TimerUtils.start((String)(this.getClass().getName() + "#preReceive"));){
                    for (PreReceiveHook hook : DefaultBuiltInHookHandlerFactory.this.pluginAccessor.getEnabledModulesByClass(PreReceiveHook.class)) {
                        Throwable throwable;
                        Timer timer;
                        block39: {
                            boolean bl;
                            block40: {
                                block41: {
                                    timer = TimerUtils.start((String)(hook.getClass().getName() + "#onReceive"));
                                    throwable = null;
                                    if (hook.onReceive(repository, refChanges, response)) break block39;
                                    bl = false;
                                    if (timer == null) break block40;
                                    if (throwable == null) break block41;
                                    try {
                                        timer.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    break block40;
                                }
                                timer.close();
                            }
                            return bl;
                        }
                        try {
                            if (timer == null) continue;
                            if (throwable != null) {
                                try {
                                    timer.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            timer.close();
                            continue;
                            {
                                catch (Throwable x2) {
                                    try {
                                        throwable = x2;
                                        throw x2;
                                    }
                                    catch (Throwable throwable2) {
                                        if (timer != null) {
                                            if (throwable != null) {
                                                try {
                                                    timer.close();
                                                }
                                                catch (Throwable x22) {
                                                    throwable.addSuppressed(x22);
                                                }
                                            } else {
                                                timer.close();
                                            }
                                        }
                                        throw throwable2;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            response.err().println("Hook " + hook.getClass().getName() + " failed. Error: ");
                            response.err().println(e.getMessage());
                            log.warn("PreReceiveHook failed, push will be rejected.", (Throwable)e);
                            boolean bl = false;
                            if (loopTimer != null) {
                                if (var4_4 != null) {
                                    try {
                                        loopTimer.close();
                                    }
                                    catch (Throwable x2) {
                                        var4_4.addSuppressed(x2);
                                    }
                                } else {
                                    loopTimer.close();
                                }
                            }
                            return bl;
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        };
    }

    @Nonnull
    public HookHandler postReceive(final @Nonnull Repository repository, final @Nonnull Collection<RefChange> refChanges) {
        return new HookHandler(){

            public boolean handle(HookRequest request, HookResponse response) {
                try (Timer loopTimer = TimerUtils.start((String)(this.getClass().getName() + "#postReceive"));){
                    for (PostReceiveHook hook : DefaultBuiltInHookHandlerFactory.this.pluginAccessor.getEnabledModulesByClass(PostReceiveHook.class)) {
                        try {
                            Timer timer = TimerUtils.start((String)(hook.getClass().getName() + "#onReceive"));
                            Throwable throwable = null;
                            try {
                                hook.onReceive(repository, refChanges, response);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (timer == null) continue;
                                if (throwable != null) {
                                    try {
                                        timer.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                timer.close();
                            }
                        }
                        catch (Exception e) {
                            log.warn("Hook {} failed.", (Object)hook.getClass().getName(), (Object)e);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        };
    }
}

