/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class SecureCrowdDirectoryServiceImpl
implements CrowdDirectoryService {
    private final CrowdDirectoryService crowdDirectoryService;
    private final ApplicationManager applicationManager;
    private final ApplicationFactory applicationFactory;

    public SecureCrowdDirectoryServiceImpl(CrowdDirectoryService crowdDirectoryService, ApplicationManager applicationManager, ApplicationFactory applicationFactory) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.applicationFactory = applicationFactory;
        this.applicationManager = applicationManager;
    }

    public Directory addDirectory(Directory directory) throws OperationFailedException {
        Directory addedDirectory = this.crowdDirectoryService.addDirectory(directory);
        try {
            this.applicationManager.addDirectoryMapping(this.applicationFactory.getApplication(), addedDirectory, true, OperationType.values());
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            throw new OperationFailedException(e);
        }
        return addedDirectory;
    }

    public void testConnection(Directory directory) throws OperationFailedException {
        this.crowdDirectoryService.testConnection(directory);
    }

    public List<Directory> findAllDirectories() {
        return this.crowdDirectoryService.findAllDirectories();
    }

    public Directory findDirectoryById(long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId);
    }

    public Directory updateDirectory(Directory directory) throws OperationFailedException {
        return this.crowdDirectoryService.updateDirectory(directory);
    }

    public void setDirectoryPosition(long directoryId, int position) throws OperationFailedException {
        this.crowdDirectoryService.setDirectoryPosition(directoryId, position);
    }

    @Transactional
    public boolean removeDirectory(long directoryId) throws DirectoryCurrentlySynchronisingException, OperationFailedException {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory != null) {
            try {
                this.applicationManager.removeDirectoryFromApplication(directory, this.applicationFactory.getApplication());
            }
            catch (ApplicationManagerException e) {
                throw new OperationFailedException((Throwable)e);
            }
            return this.crowdDirectoryService.removeDirectory(directoryId);
        }
        return false;
    }

    public boolean supportsNestedGroups(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.supportsNestedGroups(directoryId);
    }

    public boolean isDirectorySynchronisable(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.isDirectorySynchronisable(directoryId);
    }

    public void synchroniseDirectory(long directoryId) throws OperationFailedException {
        this.crowdDirectoryService.synchroniseDirectory(directoryId);
    }

    public void synchroniseDirectory(long directoryId, boolean runInBackground) throws OperationFailedException {
        this.crowdDirectoryService.synchroniseDirectory(directoryId, runInBackground);
    }

    public boolean isDirectorySynchronising(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.isDirectorySynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.getDirectorySynchronisationInformation(directoryId);
    }

    public void setConnectionPoolProperties(ConnectionPoolProperties poolProperties) {
        this.crowdDirectoryService.setConnectionPoolProperties(poolProperties);
    }

    public ConnectionPoolProperties getStoredConnectionPoolProperties() {
        return this.crowdDirectoryService.getStoredConnectionPoolProperties();
    }

    public ConnectionPoolProperties getSystemConnectionPoolProperties() {
        return this.crowdDirectoryService.getSystemConnectionPoolProperties();
    }
}

