/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.concurrent.LockService;
import com.atlassian.stash.concurrent.PullRequestLock;
import com.atlassian.stash.concurrent.RepositoryLock;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.concurrent.ReentrantPullRequestLock;
import com.atlassian.stash.util.concurrent.ReentrantRepositoryLock;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;

@AvailableToPlugins(value=LockService.class)
@Service(value="lockService")
public class DefaultLockService
implements InternalLockService {
    private final ConcurrentMap<String, ReentrantLock> locks;
    private final ConcurrentMap<String, PullRequestLock> pullRequestLocks;
    private final ConcurrentMap<String, RepositoryLock> repositoryLocks;
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public DefaultLockService(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.locks = Maps.newConcurrentMap();
        this.pullRequestLocks = Maps.newConcurrentMap();
        this.repositoryLocks = Maps.newConcurrentMap();
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalPullRequest pullRequest, @Nonnull Operation<T, E> operation) throws E {
        return this.doWithLock(pullRequest, operation, null);
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalPullRequest pullRequest, @Nonnull Operation<T, E> operation, Propagation propagation) throws E {
        return this.doWithLock(this.getLock(InternalPullRequest.class, pullRequest.getGlobalId()), operation, propagation);
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalRepository repository, @Nonnull Operation<T, E> operation) throws E {
        return this.doWithLock(repository, operation, null);
    }

    public <T, E extends Exception> T doWithLock(@Nonnull InternalRepository repository, @Nonnull Operation<T, E> operation, Propagation propagation) throws E {
        return this.doWithLock(this.getLock(InternalRepository.class, repository.getId().intValue()), operation, propagation);
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public Lock getLock(@Nonnull String lockName) {
        Lock lock = (Lock)this.locks.get(Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
        if (lock != null) {
            return lock;
        }
        this.locks.putIfAbsent(lockName, new ReentrantLock());
        return (Lock)this.locks.get(lockName);
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public PullRequestLock getPullRequestLock(@Nonnull String lockName) {
        PullRequestLock lock = (PullRequestLock)this.pullRequestLocks.get(Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
        if (lock != null) {
            return lock;
        }
        this.pullRequestLocks.putIfAbsent(lockName, (PullRequestLock)new ReentrantPullRequestLock());
        return (PullRequestLock)this.pullRequestLocks.get(lockName);
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public RepositoryLock getRepositoryLock(@Nonnull String lockName) {
        RepositoryLock lock = (RepositoryLock)this.repositoryLocks.get(Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
        if (lock != null) {
            return lock;
        }
        this.repositoryLocks.putIfAbsent(lockName, (RepositoryLock)new ReentrantRepositoryLock());
        return (RepositoryLock)this.repositoryLocks.get(lockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T doWithLock(Lock lock, Operation<T, E> operation, Propagation propagation) throws E {
        if (propagation == null) {
            propagation = Propagation.SUPPORTS;
        }
        TransactionStatus txStatus = null;
        lock.lock();
        try {
            txStatus = this.transactionManager.getTransaction(SpringTransactionUtils.definitionFor((int)propagation.value()));
            Object result = operation.perform();
            this.transactionManager.commit(txStatus);
            txStatus = null;
            Object object = result;
            return (T)object;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.transactionManager.commit(txStatus);
            txStatus = null;
            throw e;
        }
        finally {
            try {
                if (txStatus != null) {
                    this.transactionManager.rollback(txStatus);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private Lock getLock(Class<?> clazz, long id) {
        return this.getLock(clazz.getName() + "#" + id);
    }
}

