/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.event.commit.CommitDiscussionParticipantsUpdatedEvent;
import com.atlassian.stash.exception.NoSuchChangesetException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.commit.CommitDiscussionDao;
import com.atlassian.stash.internal.commit.CommitDiscussionParticipantDao;
import com.atlassian.stash.internal.commit.CommitDiscussionRequest;
import com.atlassian.stash.internal.commit.CommitDiscussionSource;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.CommitCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="commitDiscussionSource")
public class DefaultCommitDiscussionSource
implements CommitDiscussionSource {
    private final StashAuthenticationContext authenticationContext;
    private final CommitDiscussionDao discussionDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ConcurrentOperationMap<CommitDiscussionRequest, InternalCommitDiscussion> operationMap;
    private final CommitDiscussionParticipantDao participantDao;
    private final ScmService scmService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final InternalWatcherService watcherService;

    @Autowired
    public DefaultCommitDiscussionSource(StashAuthenticationContext authenticationContext, CommitDiscussionDao discussionDao, EventPublisher eventPublisher, I18nService i18nService, CommitDiscussionParticipantDao participantDao, ScmService scmService, PlatformTransactionManager transactionManager, UserService userService, InternalWatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.discussionDao = discussionDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.participantDao = participantDao;
        this.scmService = scmService;
        this.userService = userService;
        this.watcherService = watcherService;
        this.operationMap = new ConcurrentOperationMapImpl();
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Override
    public InternalCommitDiscussion get(@Nonnull CommitDiscussionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalCommitDiscussion discussion = this.doGet(request);
        if (discussion != null && request.isParticipate()) {
            this.maybeAddParticipant(discussion);
        }
        return discussion;
    }

    private void addParticipant(InternalCommitDiscussion discussion, StashUser user) {
        this.participantDao.create((Object)((InternalCommitDiscussionParticipant.Builder)new InternalCommitDiscussionParticipant.Builder(discussion).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
        this.watcherService.addUserAsWatcher((InternalWatchable)discussion, user);
        this.eventPublisher.publish((Object)new CommitDiscussionParticipantsUpdatedEvent((Object)this, (CommitDiscussion)discussion, Collections.singleton(user), Collections.emptySet()));
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion) {
        this.maybeAddParticipant(discussion, this.authenticationContext.getCurrentUser());
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion, StashUser user) {
        InternalCommitDiscussionParticipant participant = this.participantDao.findByDiscussionAndUser(discussion.getId(), user.getId().intValue());
        if (participant == null) {
            this.addParticipant(discussion, user);
        }
    }

    private InternalCommitDiscussion doGet(CommitDiscussionRequest request) {
        try {
            return (InternalCommitDiscussion)this.operationMap.runOperation((Object)request, (Callable)new GetDiscussion(request));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private class GetDiscussion
    implements Callable<InternalCommitDiscussion> {
        private final String commitId;
        private final boolean create;
        private final Repository repository;

        public GetDiscussion(CommitDiscussionRequest request) {
            this.commitId = request.getCommitId();
            this.create = request.isCreate();
            this.repository = request.getRepository();
        }

        @Override
        public InternalCommitDiscussion call() {
            InternalCommitDiscussion discussion = DefaultCommitDiscussionSource.this.discussionDao.findByRepositoryAndCommit(this.repository.getId().intValue(), this.commitId);
            if (this.create && discussion == null) {
                final Changeset found = (Changeset)DefaultCommitDiscussionSource.this.scmService.getCommandFactory(this.repository).commit(((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().changesetId(this.commitId)).build()).call();
                if (found == null) {
                    throw new NoSuchChangesetException(DefaultCommitDiscussionSource.this.i18nService.createKeyedMessage("", new Object[0]), this.commitId);
                }
                discussion = DefaultCommitDiscussionSource.this.discussionDao.findByRepositoryAndCommit(this.repository.getId().intValue(), found.getId());
                if (discussion == null) {
                    discussion = (InternalCommitDiscussion)DefaultCommitDiscussionSource.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalCommitDiscussion>(){

                        public InternalCommitDiscussion doInTransaction(TransactionStatus transactionStatus) {
                            StashUser author;
                            InternalCommitDiscussion discussion = (InternalCommitDiscussion)DefaultCommitDiscussionSource.this.discussionDao.create((Object)new InternalCommitDiscussion.Builder(InternalConverter.convertToInternalRepository((Repository)GetDiscussion.this.repository), found.getId()).parents(found.getParents()).build());
                            String emailAddress = found.getAuthor().getEmailAddress();
                            if (StringUtils.isNotBlank((CharSequence)emailAddress) && (author = DefaultCommitDiscussionSource.this.userService.findUserByNameOrEmail(emailAddress)) != null) {
                                DefaultCommitDiscussionSource.this.addParticipant(discussion, author);
                            }
                            return discussion;
                        }
                    });
                }
            }
            return discussion;
        }
    }
}

