/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.commit.CommitEnricher;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.InternalChangeset;
import com.atlassian.stash.idx.ChangesetAttributeConfiguration;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=CommitEnricher.class)
@Component(value="commitEnricher")
@Transactional(readOnly=true)
public class DatabaseCommitEnricher
implements CommitEnricher {
    private final RepositoryActivityDao activityDao;
    private final StashAuthenticationContext authenticationContext;
    private final ChangesetAttributeConfiguration configuration;
    private final InternalUserService userService;
    @Autowired
    private final ChangesetIndex index = null;

    @Autowired
    public DatabaseCommitEnricher(RepositoryActivityDao activityDao, StashAuthenticationContext authenticationContext, ChangesetAttributeConfiguration configuration, InternalUserService userService) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.configuration = configuration;
        this.userService = userService;
    }

    @Nonnull
    public Changeset enrich(@Nonnull Repository repository, @Nonnull Changeset commit, Collection<String> attributeNames) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)commit, (Object)"commit");
        return (Changeset)this.createEnricher(repository, Collections.singleton(commit), attributeNames).apply((Object)commit);
    }

    @Nonnull
    public Iterable<Changeset> enrich(@Nonnull Repository repository, @Nonnull Iterable<Changeset> commits, @Nullable Collection<String> attributeNames) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(commits, (Object)"commit");
        return Iterables.transform(commits, this.createEnricher(repository, commits, attributeNames));
    }

    @Nonnull
    public Page<Changeset> enrich(@Nonnull Repository repository, @Nonnull Page<Changeset> page, Collection<String> attributeNames) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(page, (Object)"page");
        return page.transform(this.createEnricher(repository, page.getValues(), attributeNames));
    }

    private Function<Changeset, Changeset> createEnricher(Repository repository, Iterable<Changeset> commits, Collection<String> attributeNames) {
        Set commitIds = Chainable.chain(commits).transform(Changeset.TO_ID).toSet();
        Map attributesByCommit = this.index.getAttributeValues((Collection)commitIds, this.getAttributesToLoad(repository, attributeNames));
        Map<String, Long> commentsByCommit = this.mapCommentsByCommit(repository.getId(), commitIds);
        Map<String, StashUser> usersByEmail = this.mapUsersByEmail(commits);
        if (attributesByCommit.isEmpty() && usersByEmail.isEmpty() && commentsByCommit.isEmpty()) {
            return Functions.identity();
        }
        return new Enricher(attributesByCommit, commentsByCommit, usersByEmail);
    }

    private Set<String> getAttributesToLoad(Repository repository, Collection<String> attributesRequested) {
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll((Iterable)this.configuration.getAttributesToPreload(repository));
        if (attributesRequested != null) {
            builder.addAll(attributesRequested);
        }
        return builder.build();
    }

    private Map<String, Long> mapCommentsByCommit(int repositoryId, Set<String> commitIds) {
        if (this.authenticationContext.isAuthenticated()) {
            return this.activityDao.countCommentsByCommit(repositoryId, commitIds);
        }
        return Collections.emptyMap();
    }

    private Map<String, StashUser> mapUsersByEmail(Iterable<Changeset> commits) {
        Set emailAddresses = Chainable.chain(commits).transform(Changeset.TO_AUTHOR).transform(Person.TO_EMAIL_ADDRESS).filter(PredicateUtils.notBlank()).toSet();
        return this.userService.mapUsersByEmail(emailAddresses);
    }

    private static class Enricher
    implements Function<Changeset, Changeset> {
        private final Map<String, AttributeMap> attributesByCommit;
        private final Map<String, Long> commentsByCommit;
        private final Map<String, StashUser> usersByEmail;

        private Enricher(Map<String, AttributeMap> attributesByCommit, Map<String, Long> commentsByCommit, Map<String, StashUser> usersByEmail) {
            this.attributesByCommit = attributesByCommit;
            this.commentsByCommit = commentsByCommit;
            this.usersByEmail = usersByEmail;
        }

        public Changeset apply(Changeset commit) {
            Long comments;
            AttributeMap attributes;
            InternalChangeset.Builder builder = null;
            StashUser user = this.usersByEmail.get(commit.getAuthor().getEmailAddress());
            if (user != null) {
                builder = new InternalChangeset.Builder(commit).author((Person)user);
            }
            if ((attributes = this.attributesByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new InternalChangeset.Builder(commit);
                }
                builder.attributes(attributes);
            }
            if ((comments = this.commentsByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new InternalChangeset.Builder(commit);
                }
                builder.attribute("commentCount", comments.toString());
            }
            return builder == null ? commit : builder.build();
        }
    }
}

