/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cache;

import com.atlassian.stash.internal.cache.Cache;
import com.atlassian.stash.internal.cache.CacheManager;
import com.atlassian.stash.internal.cache.SimpleValueWrapper;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class EhCacheCacheManager
extends org.springframework.cache.ehcache.EhCacheCacheManager
implements CacheManager {
    public Cache getCache(@Nonnull String name) {
        org.springframework.cache.Cache unwrapped = super.getCache((String)Preconditions.checkNotNull((Object)name, (Object)"name"));
        return unwrapped == null ? null : new EhCacheCache((Ehcache)unwrapped.getNativeCache());
    }

    private static class EhCacheCache
    extends org.springframework.cache.ehcache.EhCacheCache
    implements Cache {
        public EhCacheCache(Ehcache ehcache) {
            super(ehcache);
        }

        public Cache.ValueWrapper get(Object key) {
            Element element = this.getNativeCache().get(key);
            return element != null ? new SimpleValueWrapper(element.getObjectValue()) : null;
        }

        public <T> T get(Object key, Class<T> type) {
            Object value;
            Element element = this.getNativeCache().get(key);
            Object object = value = element != null ? element.getObjectValue() : null;
            if (type != null && value != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
            }
            return (T)value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evict(Object key, Object expectedValue) {
            Ehcache cache = this.getNativeCache();
            cache.acquireWriteLockOnKey(key);
            try {
                Element element = cache.getQuiet(key);
                if (element == null || !Objects.equals(element.getObjectValue(), expectedValue)) {
                    boolean bl = false;
                    return bl;
                }
                cache.remove(key);
                boolean bl = true;
                return bl;
            }
            finally {
                cache.releaseWriteLockOnKey(key);
            }
        }

        public Object putIfAbsent(Object key, Object value) {
            Element element = this.getNativeCache().putIfAbsent(new Element(key, value));
            return element == null ? null : element.getObjectValue();
        }

        public boolean replace(Object key, Object expectedValue, Object newValue) {
            return this.getNativeCache().replace(new Element(key, expectedValue), new Element(key, newValue));
        }
    }
}

