/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.avatar.AvatarService;
import com.atlassian.stash.avatar.AvatarStoreException;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.avatar.SimpleAvatarSupplier;
import com.atlassian.stash.event.ProjectDeletedEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={AvatarService.class})
@Service(value="avatarService")
@Transactional(propagation=Propagation.SUPPORTS)
public class ConfigurableAvatarService
extends AbstractService
implements InternalAvatarService {
    public static final String DEFAULT_SOURCE = "default";
    public static final String DISABLED_SOURCE = "disabled";
    private static final Pattern PATTERN_DATA_URI = Pattern.compile("data:([^;]+);base64,([A-Za-z0-9+/]+)=*$");
    private static final Logger log = LoggerFactory.getLogger(ConfigurableAvatarService.class);
    private final AtomicReference<AvatarSource> activeSource;
    private final AvatarSource defaultSource;
    private final AvatarSource disabledSource;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final InternalApplicationPropertiesService propertiesService;
    private final AvatarRepository repository;

    @Autowired
    public ConfigurableAvatarService(I18nService i18nService, NavBuilder navBuilder, InternalApplicationPropertiesService propertiesService, AvatarRepository repository, @Qualifier(value="urlAvatarSource") AvatarSource defaultSource, @Qualifier(value="webResourceAvatarSource") AvatarSource disabledSource) {
        this.defaultSource = defaultSource;
        this.disabledSource = disabledSource;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.repository = repository;
        this.activeSource = DISABLED_SOURCE.equals(propertiesService.getAvatarSource()) ? new AtomicReference<AvatarSource>(disabledSource) : new AtomicReference<AvatarSource>(defaultSource);
    }

    @Nonnull
    @Unsecured(value="Creating a supplier from a data URI requires no specific permission")
    public AvatarSupplier createSupplierFromDataUri(@Nonnull String uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        uri = uri.replaceAll("\\s", "").replace('-', '+').replace('_', '/');
        Matcher matcher = PATTERN_DATA_URI.matcher(uri);
        if (!matcher.matches()) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("stash.service.avatar.invaliddatauri", new Object[0]));
        }
        String contentType = matcher.group(1);
        String data = matcher.group(2);
        ByteArrayInputStream base64Data = new ByteArrayInputStream(StringUtils.getBytesUtf8((String)data));
        return new SimpleAvatarSupplier(contentType, (InputStream)new Base64InputStream((InputStream)base64Data));
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void deleteForUser(@Nonnull StashUser user) {
        if (user.getId() != null) {
            this.repository.delete(AvatarType.USER, (Object)user.getId());
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public void deleteTemporary(@Nonnull String id) {
        this.repository.deleteTemporary(id);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForProject(@Nonnull Project project, int size) {
        Preconditions.checkArgument((((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId() != null ? 1 : 0) != 0, (Object)"The provided project has not been persisted; avatars may not be retrieved for transient projects");
        return this.repository.load(AvatarType.PROJECT, (Object)project.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForUser(@Nonnull StashUser user, int size) {
        Preconditions.checkArgument((((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId() != null ? 1 : 0) != 0, (Object)"The provided user has not been persisted; avatars may not be retrieved for transient users");
        return this.repository.load(AvatarType.USER, (Object)user.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getProjectDefault(int size) {
        return this.repository.loadDefault(AvatarType.PROJECT, size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        StashUser user;
        Preconditions.checkNotNull((Object)person, (Object)"person");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        if (person instanceof StashUser && (user = (StashUser)person).getId() != null && this.repository.isStored(AvatarType.USER, (Object)user.getId())) {
            NavBuilder.Builder builder = this.navBuilder.user(user).avatar(request.getSize());
            return request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }
        return this.activeSource.get().getUrlForPerson(person, request);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForProject(@Nonnull Project project, @Nonnull AvatarRequest request) {
        return (String)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).accept((ProjectVisitor)new AvatarProjectVisitor(request));
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getUserDefault(int size) {
        return this.repository.loadDefault(AvatarType.USER, size);
    }

    @Unsecured(value="Anyone is allowed to check whether avatars are enabled")
    public boolean isEnabled() {
        return this.activeSource.get() == this.defaultSource;
    }

    @Unsecured(value="Anyone is allowed to check whether a user's avatar is locally stored")
    public boolean isLocalForUser(@Nonnull StashUser user) {
        return this.repository.isStored(AvatarType.USER, (Object)((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId());
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.cleanup(AvatarType.PROJECT, event.getProject().getId());
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        this.cleanup(AvatarType.USER, event.getDeletedUser().getId());
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public AvatarSupplier readTemporary(@Nonnull String id) {
        return this.repository.loadTemporary(id);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void saveForProject(@Nonnull Project project, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkArgument((((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId() != null ? 1 : 0) != 0, (Object)"The provided project has not been persisted; avatars may not be stored for transient projects");
        this.repository.store(AvatarType.PROJECT, (Object)project.getId(), supplier);
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void saveForUser(@Nonnull StashUser user, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkArgument((((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId() != null ? 1 : 0) != 0, (Object)"The provided user has not been persisted; avatars may not be stored for transient users");
        this.repository.store(AvatarType.USER, (Object)user.getId(), supplier);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public String saveTemporary(@Nonnull AvatarSupplier supplier) {
        return this.repository.storeTemporary(supplier);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setEnabled(boolean enabled) {
        this.propertiesService.setAvatarSource(enabled ? DEFAULT_SOURCE : DISABLED_SOURCE);
        if (enabled) {
            this.activeSource.compareAndSet(this.disabledSource, this.defaultSource);
        } else {
            this.activeSource.compareAndSet(this.defaultSource, this.disabledSource);
        }
    }

    private void cleanup(AvatarType type, Object id) {
        try {
            this.repository.delete(type, id);
        }
        catch (AvatarStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not cleanup avatars for " + type + " " + id, (Throwable)e);
            }
            log.warn("Could not cleanup avatars for " + type + " " + id + ": " + e.getMessage());
        }
    }

    private class AvatarProjectVisitor
    implements ProjectVisitor<String> {
        private final AvatarRequest request;

        private AvatarProjectVisitor(AvatarRequest request) {
            this.request = (AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public String visit(@Nonnull Project project) {
            NavBuilder.Builder builder = ConfigurableAvatarService.this.navBuilder.project(project).avatar(this.request.getSize());
            return this.request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }

        public String visit(@Nonnull PersonalProject project) {
            return ConfigurableAvatarService.this.getUrlForPerson((Person)project.getOwner(), this.request);
        }
    }
}

