/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationFailureHandler;
import com.atlassian.stash.nav.NavBuilder;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;

public class RedirectingAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private final NavBuilder navBuilder;

    public RedirectingAuthenticationFailureHandler(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if ("basic".equals(context.getMethod())) {
            return false;
        }
        String next = context.getRequest().getParameter("next");
        context.getResponse().sendRedirect(this.buildRedirectUrl(next));
        return true;
    }

    private String buildRedirectUrl(String next) {
        NavBuilder.Builder login = this.navBuilder.login();
        return (StringUtils.isBlank((String)next) ? login : login.withParam("next", next)).buildRelative();
    }
}

