/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.request.RequestEndedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PreAuthenticationFailedException;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Operation;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="securityService")
@AvailableToPlugins(value=SecurityService.class)
public class SecurityServiceImpl
implements SecurityService {
    private final Logger log = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private final UserService userService;
    private final StashAuthenticationContext authenticationContext;
    private final I18nService i18nService;

    @Autowired
    public SecurityServiceImpl(UserService userService, StashAuthenticationContext authenticationContext, I18nService i18nService) {
        this.userService = userService;
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T doAnonymously(@Nonnull String reason, @Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull((Object)reason, (Object)"reason cannot be null");
        Preconditions.checkNotNull(operation, (Object)"operation cannot be null");
        StashUser curUser = this.authenticationContext.getCurrentUser();
        Object result = null;
        try {
            this.userService.unauthenticate();
            this.log.trace("doAnonymously: running as anonymously, reason: " + reason);
            result = operation.perform();
        }
        finally {
            this.userService.unauthenticate();
            if (curUser != null) {
                this.userService.preauthenticate(curUser.getName());
            }
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T doAsUser(@Nonnull String reason, @Nonnull String userName, @Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull((Object)reason, (Object)"reason cannot be null");
        Preconditions.checkNotNull((Object)userName, (Object)"userName cannot be null");
        Preconditions.checkNotNull(operation, (Object)"operation cannot be null");
        StashUser curUser = this.authenticationContext.getCurrentUser();
        Object result = null;
        try {
            StashUser runAsUser = this.userService.preauthenticate(userName);
            if (runAsUser == null) {
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.user.preauthfail", "Could not pre-authenticate as {0}", new Object[]{userName});
                throw new PreAuthenticationFailedException(message);
            }
            this.log.trace("doAsUser: running as user " + userName + ", reason: " + reason);
            result = operation.perform();
        }
        finally {
            this.userService.unauthenticate();
            if (curUser != null) {
                this.userService.preauthenticate(curUser.getName());
            }
        }
        return (T)result;
    }

    public <T, E extends Throwable> T doWithPermission(@Nonnull String reason, @Nonnull Permission permission, @Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull((Object)permission, (Object)"permission cannot be null");
        return this.doWithPermissions(reason, Collections.singleton(permission), operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T doWithPermissions(@Nonnull String reason, @Nonnull Collection<Permission> permissions, @Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull((Object)reason, (Object)"reason cannot be null");
        Preconditions.checkNotNull(permissions, (Object)"permissions cannot be null");
        Preconditions.checkNotNull(operation, (Object)"operation cannot be null");
        Object result = null;
        Authentication authToken = SecurityContextHolder.getContext().getAuthentication();
        try {
            EnumSet<Permission> runWithPermissions = EnumSet.copyOf(permissions);
            if (authToken instanceof StashUserAuthenticationToken) {
                runWithPermissions.addAll(((StashUserAuthenticationToken)authToken).getRunWithPermissions());
            }
            StashUserAuthenticationToken runAsToken = new StashUserAuthenticationToken(this.authenticationContext.getCurrentUser(), runWithPermissions);
            SecurityContextHolder.getContext().setAuthentication((Authentication)runAsToken);
            this.log.trace("doWithPermission: running as user {} with permissions {}, reason: {}", new Object[]{runAsToken.getName(), runWithPermissions, reason});
            result = operation.perform();
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(authToken);
        }
        return (T)result;
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        SecurityContextHolder.clearContext();
    }
}

