/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.RepositoryAccessedEvent;
import com.atlassian.stash.event.RepositoryDeletionRequestedEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.user.InternalRecentlyAccessedRepositoriesService;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.internal.user.RepositoryAccessDao;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.RecentlyAccessedRepositoriesService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=RecentlyAccessedRepositoriesService.class)
@Service(value="recentlyAccessedRepositoriesService")
public class RecentlyAccessedRepositoriesServiceImpl
extends AbstractService
implements InternalRecentlyAccessedRepositoriesService {
    public static final int RETAIN_REPO_ACCESS_COUNT = 15;
    private static final Logger log = LoggerFactory.getLogger(RecentlyAccessedRepositoriesServiceImpl.class);
    private final StashAuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionPredicateFactory permissionPredicateFactory;
    private final PermissionService permissionService;
    private final RepositoryAccessDao repositoryAccessDao;
    private final RepositoryService repositoryService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    public RecentlyAccessedRepositoriesServiceImpl(StashAuthenticationContext authenticationContext, I18nService i18nService, PermissionPredicateFactory permissionPredicateFactory, PermissionService permissionService, RepositoryAccessDao repositoryAccessDao, RepositoryService repositoryService, PlatformTransactionManager transactionManager, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionPredicateFactory = permissionPredicateFactory;
        this.permissionService = permissionService;
        this.repositoryAccessDao = repositoryAccessDao;
        this.repositoryService = repositoryService;
        this.userService = userService;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Nonnull
    public Page<Repository> findByCurrentUser(@Nonnull PageRequest pageRequest) {
        return this.findByCurrentUser(Permission.REPO_READ, pageRequest);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Nonnull
    public Page<Repository> findByCurrentUser(@Nonnull Permission permission, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)permission, (Object)"permission");
        this.validateRepositoryPermission(permission);
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        StashUser user = this.authenticationContext.getCurrentUser();
        Predicate predicate = this.permissionPredicateFactory.createRepositoryPermissionPredicate(permission);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryAccessDao.findRecentRepositories(user.getId().intValue(), pageRequest, predicate));
    }

    @EventListener
    public void onRepositoryAccessed(final RepositoryAccessedEvent event) {
        if (event.getUser() != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(TransactionStatus status) {
                    Repository repository = RecentlyAccessedRepositoriesServiceImpl.this.repositoryService.getById(event.getRepository().getId().intValue());
                    StashUser user = RecentlyAccessedRepositoriesServiceImpl.this.userService.getUserById(event.getUser().getId().intValue());
                    RecentlyAccessedRepositoriesServiceImpl.this.repositoryAccessDao.update((Object)new InternalRepositoryAccess.Builder().lastAccessed(event.getDate()).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((StashUser)user)).build());
                    return null;
                }
            });
        }
    }

    @EventListener
    public void onRepositoryDeleteRequested(RepositoryDeletionRequestedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Repository repository = event.getRepository();
        try {
            this.repositoryAccessDao.deleteAllAccessesForRepository(repository.getId().intValue());
        }
        catch (RuntimeException e) {
            log.warn("Repository accesses for " + repository.getProject().getKey() + "/" + repository.getSlug() + " could not be deleted", (Throwable)e);
            event.cancel(this.i18nService.getKeyedText("stash.service.recentrepositories.cleanupfailed", "Recent repositories entries for {0}/{1} could not be removed. The repository may not be deleted.", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    @EventListener
    public void onUserDeleted(final UserCleanupEvent event) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                RecentlyAccessedRepositoriesServiceImpl.this.repositoryAccessDao.deleteAllAccessesForUser(event.getDeletedUser().getId().intValue());
                return null;
            }
        });
    }

    @Transactional
    public void trimForUser(final @Nonnull StashUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        this.repositoryAccessDao.trimRecentRepositories(user.getId().intValue(), 15, (Predicate)new Predicate<InternalRepositoryAccess>(){

            public boolean apply(InternalRepositoryAccess access) {
                return RecentlyAccessedRepositoriesServiceImpl.this.permissionService.hasRepositoryPermission(user, (Repository)access.getRepository(), Permission.REPO_READ);
            }
        });
    }

    private void validateRepositoryPermission(Permission permission) {
        if (!permission.isResource(Repository.class)) {
            throw new ArgumentValidationException(this.i18nService.getKeyedText("stash.service.recentrepositories.invalidpermission", "{0} is not a repository permission", new Object[]{permission}));
        }
    }
}

