/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.GroupPermissionCriteria;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.InternalStashAuthenticationContext;
import com.atlassian.stash.internal.user.PartitionedGroups;
import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.internal.user.PermissionGraphFactory;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.UserPermissionCriteria;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UserUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=PermissionService.class)
@Service(value="permissionService")
public class PermissionServiceImpl
extends AbstractService
implements InternalPermissionService {
    public static final int GROUP_PAGESIZE = 1000;
    public static final String GROUP_PERMISSION_SEARCH = "Group Permission Search";
    public static final int USER_GROUP_PAGE_LIMIT = 500;
    private static final Logger log = LoggerFactory.getLogger(PermissionServiceImpl.class);
    private final InternalStashAuthenticationContext authenticationContext;
    private final EffectivePermissionDao effectivePermissionDao;
    private final FeatureManager featureManager;
    private final PermissionGraphFactory permissionGraphFactory;
    private final ProjectDao projectDao;
    private final RepositoryDao repositoryDao;
    private final RepositoryPermissionDao repositoryPermissionDao;
    private final UserService userService;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;

    @Autowired
    public PermissionServiceImpl(InternalStashAuthenticationContext authenticationContext, EffectivePermissionDao effectivePermissionDao, FeatureManager featureManager, PermissionGraphFactory permissionGraphFactory, ProjectDao projectDao, RepositoryDao repositoryDao, RepositoryPermissionDao repositoryPermissionDao, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.effectivePermissionDao = effectivePermissionDao;
        this.featureManager = featureManager;
        this.permissionGraphFactory = permissionGraphFactory;
        this.projectDao = projectDao;
        this.repositoryDao = repositoryDao;
        this.repositoryPermissionDao = repositoryPermissionDao;
        this.userService = userService;
    }

    public boolean hasGlobalPermission(String username, @Nonnull Permission permission) {
        StashUser user = username == null ? null : this.findUserByName(username);
        return this.hasGlobalPermission(user, permission);
    }

    public boolean hasGlobalPermission(StashUser user, @Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.hasPermission(user, null, permission);
    }

    public boolean hasGlobalPermission(StashUserAuthenticationToken token, Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.hasPermission(token, null, permission);
    }

    public boolean hasGlobalPermission(@Nonnull Permission permission) {
        return this.hasGlobalPermission(this.authenticationContext.getCurrentToken(), permission);
    }

    public boolean hasAnyUserPermission(@Nonnull StashUser user, @Nonnull Permission permission) {
        CommonValidations.validateUser(user);
        CommonValidations.validateResourcePermission(permission);
        return this.hasPermission(user, null, permission);
    }

    private boolean hasAnyUserPermission(StashUserAuthenticationToken token, Permission permission) {
        CommonValidations.validateResourcePermission(permission);
        return this.hasPermission(token, null, permission);
    }

    public boolean hasAnyUserPermission(@Nonnull Permission permission) {
        StashUserAuthenticationToken token = this.authenticationContext.getCurrentToken();
        return token != null && this.hasAnyUserPermission(token, permission);
    }

    public boolean hasProjectPermission(StashUser user, @Nonnull Project project, @Nonnull Permission permission) {
        CommonValidations.validateProject(project);
        CommonValidations.validateProjectPermission(permission);
        return this.hasPermission(user, (Object)project, permission);
    }

    private boolean hasProjectPermission(StashUserAuthenticationToken token, Project project, Permission permission) {
        CommonValidations.validateProject(project);
        CommonValidations.validateProjectPermission(permission);
        return this.hasPermission(token, (Object)project, permission);
    }

    public boolean hasProjectPermission(@Nonnull Project project, @Nonnull Permission permission) {
        return this.hasProjectPermission(this.authenticationContext.getCurrentToken(), project, permission);
    }

    public boolean hasProjectPermission(int projectId, @Nonnull Permission permission) {
        return this.hasProjectPermission(this.authenticationContext.getCurrentToken(), projectId, permission);
    }

    public boolean hasProjectPermission(StashUser user, int projectId, @Nonnull Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        Project project = (Project)this.projectDao.getById((Object)projectId);
        return this.hasPermission(user, (Object)project, permission);
    }

    private boolean hasProjectPermission(StashUserAuthenticationToken token, int projectId, Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        Project project = (Project)this.projectDao.getById((Object)projectId);
        return this.hasPermission(token, (Object)project, permission);
    }

    @Nonnull
    private PermissionGraph getPermissionGraph(@Nonnull StashUserAuthenticationToken token) {
        PermissionGraph graph = token.getPermissionGraph();
        if (graph == null) {
            graph = this.createPermissionGraph(token.getPrincipal());
            token.setPermissionGraph(graph);
        }
        return graph;
    }

    @Nonnull
    private PermissionGraph createPermissionGraph(@Nonnull StashUser user) {
        CommonValidations.validateUser(user);
        return this.permissionGraphFactory.createGraph(user);
    }

    @VisibleForTesting
    PartitionedGroups getAllGroups(final String username) {
        int pageSize = 500;
        return this.partitionGroups((PagedIterable<String>)new PagedIterable((PageProvider)new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionServiceImpl.this.userService.findGroupsByUser(username, request);
            }
        }, (PageRequest)new PageRequestImpl(0, pageSize)), pageSize);
    }

    private PartitionedGroups partitionGroups(final PagedIterable<String> groups, final int partitionSize) {
        return new PartitionedGroups(){

            public Iterator<Collection<String>> iterator() {
                Iterator iterator = groups.iterator();
                if (!iterator.hasNext()) {
                    return Collections.singletonList(Collections.emptyList()).iterator();
                }
                return Iterators.partition((Iterator)iterator, (int)partitionSize);
            }
        };
    }

    private boolean hasPermission(StashUserAuthenticationToken token, Object resource, Permission permission) {
        if (token == null) {
            return false;
        }
        Set inheritingPermissions = permission.getInheritingPermissions();
        for (Permission runWithPermission : token.getRunWithPermissions()) {
            if (!inheritingPermissions.contains(runWithPermission)) continue;
            log.trace("permission granted by elevated permissions (from {}), token = {}, resource = {}, requested permission = {}", new Object[]{StashAuthenticationContext.class.getSimpleName(), token, resource, permission});
            return true;
        }
        return this.hasPermission(token.getPrincipal(), resource, permission);
    }

    private boolean hasPermission(StashUser user, Object resource, Permission permission) {
        log.trace("user = {}, resource = {}, requested permission = {}", new Object[]{user, resource, permission});
        if (user == null || !user.isActive()) {
            return false;
        }
        PermissionGraph graph = user.equals(this.authenticationContext.getCurrentUser()) ? this.getPermissionGraph(this.authenticationContext.getCurrentToken()) : this.createPermissionGraph(user);
        return graph.isGranted(permission, resource) || permission == Permission.REPO_READ && this.isPubliclyAccessible((Repository)resource) || permission == Permission.PROJECT_VIEW && this.isPubliclyAccessible((Project)resource);
    }

    public boolean hasDirectGlobalUserPermission(@Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentToken(), null, permission);
    }

    public boolean hasDirectProjectUserPermission(@Nonnull Project project, @Nonnull Permission permission) {
        CommonValidations.validateProject(project);
        CommonValidations.validateProjectPermission(permission);
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentToken(), (Object)project, permission);
    }

    public boolean hasDirectRepositoryUserPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        return this.hasDirectUserPermission(this.authenticationContext.getCurrentToken(), (Object)repository, permission);
    }

    private boolean hasDirectUserPermission(StashUserAuthenticationToken token, Object resource, Permission permission) {
        return token != null && this.hasDirectUserPermission(token.getPrincipal(), resource, permission);
    }

    private boolean hasDirectUserPermission(StashUser user, Object resource, Permission permission) {
        if (user == null || !user.isActive()) {
            return false;
        }
        Integer userId = user.getId();
        if (userId == null) {
            return false;
        }
        UserPermissionCriteria criteria = ((UserPermissionCriteria.Builder)((UserPermissionCriteria.Builder)new UserPermissionCriteria.Builder(userId.intValue()).permission(permission)).resource(resource)).build();
        boolean granted = this.effectivePermissionDao.isGrantedToUser(criteria);
        if (granted) {
            log.trace("{}: {}, or an inheriting permission, has been explicit granted", (Object)user.getName(), (Object)permission);
        } else {
            log.trace("{}: {} has not been explicitly granted", (Object)user.getName(), (Object)permission);
        }
        return granted;
    }

    public boolean hasGlobalGroupPermission(@Nonnull Permission permission, @Nonnull String group) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validateGroup(group);
        GroupPermissionCriteria criteria = ((GroupPermissionCriteria.Builder)new GroupPermissionCriteria.Builder(group).permission(permission)).build();
        return this.effectivePermissionDao.isGrantedToGroup(criteria);
    }

    public boolean isProjectAccessible(@Nonnull Project project) {
        CommonValidations.validateProject(project);
        return this.hasProjectPermission(project, Permission.PROJECT_VIEW) || this.isPubliclyAccessible(project);
    }

    public boolean isProjectAccessible(int projectId) {
        Project project = (Project)this.projectDao.getById((Object)projectId);
        return project != null && this.isProjectAccessible(project);
    }

    public boolean isRepositoryAccessible(@Nonnull Repository repository) {
        CommonValidations.validateRepository(repository);
        return this.hasRepositoryPermission(repository, Permission.REPO_READ) || this.isPubliclyAccessible(repository);
    }

    public boolean isRepositoryAccessible(int repositoryId) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        return repository != null && this.isRepositoryAccessible(repository);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean isPubliclyAccessible(@Nonnull Repository repository) {
        CommonValidations.validateRepository(repository);
        return this.featureManager.isEnabled(Feature.PUBLIC_ACCESS) && (repository.isPublic() || repository.getProject().isPublic());
    }

    public boolean isPubliclyAccessible(@Nonnull Project project) {
        CommonValidations.validateProject(project);
        return this.featureManager.isEnabled(Feature.PUBLIC_ACCESS) && (project.isPublic() || this.repositoryDao.countPublicByProject(project.getId().intValue()) > 0L);
    }

    @Nonnull
    public Page<StashUser> getGrantedUsers(@Nonnull Permission permission, @Nonnull PageRequest request) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validatePageRequest(request);
        return this.effectivePermissionDao.findUsers(permission, request, UserUtils.IS_ACTIVE);
    }

    @Nonnull
    public Page<String> getGrantedGroups(@Nonnull Permission permission, @Nonnull PageRequest request) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validatePageRequest(request);
        return this.effectivePermissionDao.findGroups(permission, request);
    }

    public boolean hasGlobalPermissionThroughGroupMembership(@Nonnull Permission permission, @Nonnull Set<String> excludedGroups) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validateGroups(excludedGroups);
        return this.hasPermissionsThroughGroup((Principal)this.authenticationContext.getCurrentToken(), null, permission, excludedGroups);
    }

    public boolean hasProjectPermissionThroughGroupMembership(@Nonnull Project project, @Nonnull Permission permission, @Nonnull Set<String> excludedGroups) {
        CommonValidations.validateProject(project);
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGroups(excludedGroups);
        return this.hasPermissionsThroughGroup((Principal)this.authenticationContext.getCurrentToken(), project, permission, excludedGroups);
    }

    public boolean hasRepositoryPermissionThroughGroupMembership(@Nonnull Repository repository, @Nonnull Permission permission, @Nonnull Set<String> excludedGroups) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGroups(excludedGroups);
        return this.hasPermissionsThroughGroup((Principal)this.authenticationContext.getCurrentToken(), repository, permission, excludedGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPermissionsThroughGroup(Principal user, Object resource, Permission permission, Set<String> excludedGroups) {
        String name = user.getName();
        Timer timer = TimerUtils.start((String)GROUP_PERMISSION_SEARCH);
        try {
            PageRequest pageRequest = PageUtils.newRequest((int)0, (int)500);
            Page page = this.userService.findGroupsByUser(name, pageRequest);
            while (true) {
                HashSet groups = Sets.newHashSet((Iterable)page.getValues());
                Iterables.removeAll((Iterable)groups, (Collection)Collections2.transform(excludedGroups, (Function)IdentifierUtils.TO_LOWER_CASE));
                if (groups.isEmpty()) {
                    log.trace("All groups on the page have been excluded");
                } else {
                    log.trace("Testing for permission against {} groups", (Object)groups.size());
                    GroupPermissionCriteria criteria = ((GroupPermissionCriteria.Builder)((GroupPermissionCriteria.Builder)new GroupPermissionCriteria.Builder((Iterable)groups).permission(permission)).resource(resource)).build();
                    boolean granted = this.effectivePermissionDao.isGrantedToGroup(criteria);
                    if (granted) {
                        log.trace("{}: Permission {} granted by group membership", (Object)name, (Object)permission);
                        boolean bl = true;
                        return bl;
                    }
                }
                if (page.getIsLastPage()) break;
                log.trace("{}: Loading next page of groups", (Object)name);
                page = this.userService.findGroupsByUser(name, page.getNextPageRequest());
            }
            log.trace("{}: All group memberships have been exhausted", (Object)name);
            log.trace("permission not granted by any group membership");
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    public boolean hasRepositoryPermission(StashUser user, @Nonnull Repository repository, @Nonnull Permission permission) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        return this.hasPermission(user, (Object)repository, permission);
    }

    private boolean hasRepositoryPermission(StashUserAuthenticationToken token, Repository repository, Permission permission) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        return this.hasPermission(token, (Object)repository, permission);
    }

    public boolean hasRepositoryPermission(StashUser user, int repositoryId, @Nonnull Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        return this.hasRepositoryPermission(user, repository, permission);
    }

    private boolean hasRepositoryPermission(StashUserAuthenticationToken token, int repositoryId, Permission permission) {
        Repository repository = (Repository)this.repositoryDao.getById((Object)repositoryId);
        return this.hasRepositoryPermission(token, repository, permission);
    }

    public boolean hasRepositoryPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentToken(), repository, permission);
    }

    public boolean hasRepositoryPermission(int repositoryId, @Nonnull Permission permission) {
        return this.hasRepositoryPermission(this.authenticationContext.getCurrentToken(), repositoryId, permission);
    }

    @Nonnull
    public Set<String> getUsersWithPermission(final @Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        HashSet<String> usersWithPermission = new HashSet<String>();
        Iterable users = Iterables.filter((Iterable)new PagedIterable((PageProvider)new PageProvider<StashUser>(){

            public Page<StashUser> get(PageRequest request) {
                return PermissionServiceImpl.this.getGrantedUsers(permission, request);
            }
        }, this.maxUserPageSize), (Predicate)UserUtils.IS_ACTIVE);
        Iterables.addAll(usersWithPermission, (Iterable)Iterables.transform((Iterable)users, (Function)Functions.compose((Function)IdentifierUtils.TO_LOWER_CASE, (Function)UserUtils.TO_USERNAME)));
        PagedIterable groups = new PagedIterable((PageProvider)new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionServiceImpl.this.getGrantedGroups(permission, request);
            }
        }, 1000);
        for (final String group : groups) {
            Iterable usersInGroup = Iterables.filter((Iterable)new PagedIterable((PageProvider)new PageProvider<StashUser>(){

                public Page<StashUser> get(PageRequest request) {
                    return PageUtils.asPageOf(StashUser.class, (Page)PermissionServiceImpl.this.userService.findUsersByGroup(group, request));
                }
            }, this.maxUserPageSize), (Predicate)UserUtils.IS_ACTIVE);
            Iterables.addAll(usersWithPermission, (Iterable)Iterables.transform((Iterable)usersInGroup, (Function)Functions.compose((Function)IdentifierUtils.TO_LOWER_CASE, (Function)UserUtils.TO_USERNAME)));
        }
        return usersWithPermission;
    }

    public int getCountOfUsersWithPermission(@Nonnull Permission permission) {
        return this.getUsersWithPermission(permission).size();
    }

    public int getCountOfAccessibleRepositories(@Nonnull Project project) {
        CommonValidations.validateProject(project);
        StashUserAuthenticationToken token = this.authenticationContext.getCurrentToken();
        if (this.hasProjectPermission(token, project, Permission.PROJECT_READ)) {
            return Ints.saturatedCast((long)this.repositoryDao.countByProject(((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId().intValue()));
        }
        if (token != null && token.getPrincipal() != null) {
            StashUser user = token.getPrincipal();
            return Ints.saturatedCast((long)this.repositoryPermissionDao.countWithPermission(user.getId().intValue(), this.getAllGroups(user.getName()), project.getId().intValue()));
        }
        return 0;
    }

    public Permission getHighestGlobalPermission(StashUser user) {
        if (user == null || !user.isActive()) {
            return null;
        }
        List<Permission> globalPermissions = this.getOrderedGlobalPermissions();
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalPermission(user, globalPermission)) continue;
            return globalPermission;
        }
        return null;
    }

    public Permission getHighestGlobalPermission(String username) {
        StashUser user = username != null ? this.findUserByName(username) : null;
        return user != null ? this.getHighestGlobalPermission(user) : null;
    }

    public Permission getHighestGlobalGroupPermission(String groupName) {
        if (groupName == null) {
            return null;
        }
        List<Permission> globalPermissions = this.getOrderedGlobalPermissions();
        for (Permission globalPermission : globalPermissions) {
            if (!this.hasGlobalGroupPermission(globalPermission, groupName)) continue;
            return globalPermission;
        }
        return null;
    }

    private StashUser findUserByName(String username) {
        return this.userService.getUserByName(username);
    }

    private List<Permission> getOrderedGlobalPermissions() {
        ArrayList globalPermissions = Lists.newArrayList((Iterable)Permission.getGlobalPermissions());
        Collections.sort(globalPermissions, new Comparator<Permission>(){

            @Override
            public int compare(Permission o1, Permission o2) {
                return o1 == o2 ? 0 : (o1.getWeight() < o2.getWeight() ? 1 : (o1.getWeight() > o2.getWeight() ? -1 : 0));
            }
        });
        return globalPermissions;
    }
}

