/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionRevokedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionGrantedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionRevokedEvent;
import com.atlassian.stash.event.user.GroupCleanupEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.GroupPageFilter;
import com.atlassian.stash.internal.user.InIteratorPredicate;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.atlassian.stash.internal.user.UserPageFilter;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.PermittedGroup;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.SetPermissionRequest;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=PermissionAdminService.class)
@Service(value="permissionAdminService")
@Transactional(readOnly=true)
public class PermissionAdminServiceImpl
implements PermissionAdminService {
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return IdentifierUtils.compareToInLowerCase((String)s1, (String)s2);
        }
    };
    private static final Comparator<StashUser> CASE_INSENSITIVE_NAME_COMPARATOR = new Comparator<StashUser>(){

        @Override
        public int compare(StashUser u1, StashUser u2) {
            return IdentifierUtils.compareToInLowerCase((String)u1.getName(), (String)u2.getName());
        }
    };
    public static final int INTERNAL_PAGE_LIMIT = 500;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionDao globalPermissionDao;
    private final ProjectPermissionDao projectPermissionDao;
    private final RepositoryPermissionDao repositoryPermissionDao;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final int maxUsers;
    private final int maxGroups;
    private final PermissionService permissionService;
    private final StashAuthenticationContext authenticationContext;
    private final UserService userService;

    @Autowired
    public PermissionAdminServiceImpl(UserService userService, GlobalPermissionDao globalPermissionDao, ProjectPermissionDao projectPermissionDao, RepositoryPermissionDao repositoryPermissionDao, StashAuthenticationContext authenticationContext, PermissionService permissionService, I18nService i18nService, LicenseService licenseService, EventPublisher eventPublisher, @Value(value="${page.max.users}") int maxUsers, @Value(value="${page.max.groups}") int maxGroups) {
        this.userService = userService;
        this.globalPermissionDao = globalPermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.repositoryPermissionDao = repositoryPermissionDao;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.eventPublisher = eventPublisher;
        this.maxUsers = maxUsers;
        this.maxGroups = maxGroups;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Deprecated
    public Page<PermittedUser> getUsersWithGlobalPermission(@Nonnull PageRequest pageRequest) {
        return this.findUsersWithGlobalPermission(pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedUser> findUsersWithGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validatePageRequest(pageRequest);
        return this.globalPermissionDao.findHighestPermissionPerUser(filter, pageRequest);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Deprecated
    public Page<? extends StashUser> getUsersWithoutGlobalPermission(@Nonnull PageRequest request) {
        return this.findUsersWithoutGlobalPermission(request.getFilter(), request);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<StashUser> findUsersWithoutGlobalPermission(String filter, @Nonnull PageRequest request) {
        CommonValidations.validatePageRequest(request);
        return this.getUsersWithoutPermission(PermissionAdminServiceImpl.withoutUsers(new PageProvider<StashUser>(){

            public Page<StashUser> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.globalPermissionDao.findUsersWithPermission(request);
            }
        }), filter, request);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Deprecated
    public Page<PermittedGroup> getGroupsWithGlobalPermission(@Nonnull PageRequest pageRequest) {
        CommonValidations.validatePageRequest(pageRequest);
        return this.findGroupsWithGlobalPermission(pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedGroup> findGroupsWithGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validatePageRequest(pageRequest);
        return this.globalPermissionDao.findHighestPermissionPerGroup(filter, pageRequest);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Deprecated
    public Page<String> getGroupsWithoutGlobalPermission(@Nonnull PageRequest pageRequest) {
        return this.findGroupsWithoutGlobalPermission(pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<String> findGroupsWithoutGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validatePageRequest(pageRequest);
        return this.getGroupsWithoutPermission(filter, PermissionAdminServiceImpl.withoutGroups(new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.globalPermissionDao.findGroupsWithPermission(request);
            }
        }), pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Deprecated
    public Page<PermittedUser> getUsersWithProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithProjectPermission(project, pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedUser> findUsersWithProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateProject(project);
        CommonValidations.validatePageRequest(pageRequest);
        return this.projectPermissionDao.findHighestPermissionPerUser(project.getId().intValue(), filter, pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Deprecated
    public Page<? extends StashUser> getUsersWithoutProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithoutProjectPermission(project, pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<StashUser> findUsersWithoutProjectPermission(final @Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateProject(project);
        CommonValidations.validatePageRequest(pageRequest);
        return this.getUsersWithoutPermission(PermissionAdminServiceImpl.withoutUsers(new PageProvider<StashUser>(){

            public Page<StashUser> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.projectPermissionDao.findUsersWithPermission(project.getId().intValue(), request);
            }
        }), filter, pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Deprecated
    public Page<PermittedGroup> getGroupsWithProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithProjectPermission(project, pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedGroup> findGroupsWithProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateProject(project);
        CommonValidations.validatePageRequest(pageRequest);
        return this.projectPermissionDao.findHighestPermissionPerGroup(project.getId().intValue(), filter, pageRequest);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Deprecated
    public Page<String> getGroupsWithoutProjectPermission(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithoutProjectPermission(project, pageRequest.getFilter(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<String> findGroupsWithoutProjectPermission(final @Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateProject(project);
        CommonValidations.validatePageRequest(pageRequest);
        return this.getGroupsWithoutPermission(filter, PermissionAdminServiceImpl.withoutGroups(new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.projectPermissionDao.findGroupsWithPermission(project.getId().intValue(), request);
            }
        }), pageRequest);
    }

    private Page<StashUser> getUsersWithoutPermission(Predicate<StashUser> pageFilter, String filter, PageRequest request) {
        PageProvider<StashUser> userProvider = this.createUserProvider(filter);
        UserPageFilter userMatchFilter = new UserPageFilter(filter);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxUsers);
        return PageUtils.filterPages(userProvider, (Predicate)Predicates.and((Predicate)userMatchFilter, pageFilter), (PageRequest)pageRequest);
    }

    private Page<String> getGroupsWithoutPermission(final String groupnamePattern, Predicate<String> groupsWithoutPermissionFilter, PageRequest request) {
        PageProvider<String> groupsProvider = new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.userService.findGroupsByName(groupnamePattern, request);
            }
        };
        GroupPageFilter groupPageFilter = new GroupPageFilter(groupnamePattern);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxGroups);
        return PageUtils.filterPages((PageProvider)groupsProvider, (Predicate)Predicates.and((Predicate)groupPageFilter, groupsWithoutPermissionFilter), (PageRequest)pageRequest).transform(IdentifierUtils.TO_LOWER_CASE);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<PermittedUser> findUsersWithRepositoryPermission(@Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validatePageRequest(pageRequest);
        return this.repositoryPermissionDao.findHighestPermissionPerUser(repository.getId().intValue(), filter, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<StashUser> findUsersWithoutRepositoryPermission(final @Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validatePageRequest(pageRequest);
        return this.getUsersWithoutPermission(PermissionAdminServiceImpl.withoutUsers(new PageProvider<StashUser>(){

            public Page<StashUser> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.repositoryPermissionDao.findUsersWithPermission(repository.getId().intValue(), request);
            }
        }), filter, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<PermittedGroup> findGroupsWithRepositoryPermission(@Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validatePageRequest(pageRequest);
        return this.repositoryPermissionDao.findHighestPermissionPerGroup(repository.getId().intValue(), filter, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<String> findGroupsWithoutRepositoryPermission(final @Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validatePageRequest(pageRequest);
        return this.getGroupsWithoutPermission(filter, PermissionAdminServiceImpl.withoutGroups(new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.repositoryPermissionDao.findGroupsWithPermission(repository.getId().intValue(), request);
            }
        }), pageRequest);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        if (this.permissionService.hasGlobalPermission(group, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.revoke.insufficient.permission", "You have insufficient permission to change {0}''s permissions", new Object[]{group}));
        }
        for (Permission permission : Permission.getGlobalPermissions()) {
            InternalGlobalPermission perm = this.buildPermission(permission, group, null);
            if (!this.globalPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) continue;
            this.revokeGlobalPermission(permission, group);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull StashUser user) {
        CommonValidations.validateUser(user);
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.revoke.insufficient.permission", "You have insufficient permission to change {0}''s permissions", new Object[]{user.getDisplayName()}));
        }
        for (Permission permission : Permission.getGlobalPermissions()) {
            InternalGlobalPermission perm = this.buildPermission(permission, null, user);
            if (!this.globalPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) continue;
            this.revokeGlobalPermission(permission, user);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull String group) {
        CommonValidations.validateProject(project);
        CommonValidations.validateGroup(group);
        for (Permission permission : Permission.getPermissionsOn(Project.class)) {
            this.revokeProjectPermission(permission, project, group);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull StashUser user) {
        CommonValidations.validateProject(project);
        CommonValidations.validateUser(user);
        for (Permission permission : Permission.getPermissionsOn(Project.class)) {
            this.revokeProjectPermission(permission, project, user);
        }
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull String group) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateGroup(group);
        for (Permission permission : Permission.getPermissionsOn(Repository.class)) {
            this.revokeRepositoryPermission(permission, repository, group);
        }
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull StashUser user) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateUser(user);
        for (Permission permission : Permission.getPermissionsOn(Repository.class)) {
            this.revokeRepositoryPermission(permission, repository, user);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN') and hasGlobalPermission(#permission)")
    public void setGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        this.doSetPermission(new SetPermissionRequest.Builder().globalPermission(permission).group(group).build());
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void setProjectPermission(@Nonnull Project project, Permission permission, @Nonnull String group) {
        this.doSetPermission(new SetPermissionRequest.Builder().projectPermission(permission, project).group(group).build());
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void setRepositoryPermission(@Nonnull Repository repository, Permission permission, @Nonnull String group) {
        this.doSetPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repository).group(group).build());
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN') and hasGlobalPermission(#permission)")
    public void setGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        this.doSetPermission(new SetPermissionRequest.Builder().globalPermission(permission).user(user).build());
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void setProjectPermission(@Nonnull Project project, @Nonnull Permission permission, @Nonnull StashUser user) {
        this.doSetPermission(new SetPermissionRequest.Builder().projectPermission(permission, project).user(user).build());
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void setRepositoryPermission(@Nonnull Repository repository, @Nonnull Permission permission, @Nonnull StashUser user) {
        this.doSetPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repository).user(user).build());
    }

    @Transactional
    @Secured(value="Permissions checks done internally")
    public void setPermission(@Nonnull SetPermissionRequest request) {
        boolean hasInsufficientPermission;
        Permission permission = request.getPermission();
        Project project = request.getProject();
        Repository repository = request.getRepository();
        boolean bl = hasInsufficientPermission = permission.isGlobal() && !this.permissionService.hasGlobalPermission(Permission.max((Permission)permission, (Permission)Permission.ADMIN)) || permission.isResource(Project.class) && !this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN) || permission.isResource(Repository.class) && !this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
        if (hasInsufficientPermission) {
            throw new AuthorisationException(this.i18nService.getKeyedText("stash.service.permissionadmin.usercannotgrantpermission", "You have insufficient permission to grant {0}", new Object[]{permission}));
        }
        this.doSetPermission(request);
    }

    private void doSetPermission(@Nonnull SetPermissionRequest request) {
        Permission permission = request.getPermission();
        Project project = request.getProject();
        Repository repository = request.getRepository();
        Set users = request.getUsers();
        Set groups = request.getGroups();
        CommonValidations.validateGrantablePermission(permission);
        if (permission.isGlobal()) {
            for (StashUser user : users) {
                this.revokeAllGlobalPermissions(user);
                this.grantGlobalPermission(permission, user);
            }
            for (String group : groups) {
                this.revokeAllGlobalPermissions(group);
                this.grantGlobalPermission(permission, group);
            }
        } else if (permission.isResource(Project.class)) {
            for (StashUser user : users) {
                this.revokeAllProjectPermissions(project, user);
                this.grantPermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
            }
            for (String group : groups) {
                this.revokeAllProjectPermissions(project, group);
                this.grantPermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).group(group)).build());
            }
        } else if (permission.isResource(Repository.class)) {
            for (StashUser user : users) {
                this.revokeAllRepositoryPermissions(repository, user);
                this.grantPermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
            }
            for (String group : groups) {
                this.revokeAllRepositoryPermissions(repository, group);
                this.grantPermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).group(group)).build());
            }
        } else {
            throw new ServerException(this.i18nService.getKeyedText("stash.service.permissionadmin.cannotgrantunknownpermission", "{0} cannot grant unknown permission {1}", new Object[]{Product.NAME, permission}));
        }
    }

    private PageProvider<StashUser> createUserProvider(final String usernamePattern) {
        return new PageProvider<StashUser>(){

            public Page<StashUser> get(PageRequest request) {
                return PageUtils.asPageOf(StashUser.class, (Page)PermissionAdminServiceImpl.this.userService.findUsersByName(usernamePattern, request));
            }
        };
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN') and hasGlobalPermission(#permission)")
    public boolean hasAllGlobalPermission(@Nonnull Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        return false;
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public boolean hasAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        CommonValidations.validateProject(project);
        return this.projectPermissionDao.hasPermissionEntry((InternalGrantedPermission)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build());
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        this.licenseService.validateCanLicenseUser(user, permission);
        InternalGlobalPermission perm = this.buildPermission(permission, null, user);
        this.grantPermission(perm);
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        this.licenseService.validateCanLicenseGroup(group, permission);
        InternalGlobalPermission perm = this.buildPermission(permission, group, null);
        this.grantPermission(perm);
    }

    private void grantPermission(InternalGlobalPermission perm) {
        if (!this.globalPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) {
            this.globalPermissionDao.create((Object)perm);
            GlobalPermissionGrantedEvent event = new GlobalPermissionGrantedEvent((Object)this, perm.getPermission(), perm.getGroup(), (StashUser)perm.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    private void grantPermission(InternalProjectPermission perm) {
        if (perm.getProject().getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.personalproject.grant", "You cannot grant project permissions on a personal project.", new Object[0]));
        }
        if (!this.projectPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) {
            this.projectPermissionDao.create((Object)perm);
            ProjectPermissionGrantedEvent event = new ProjectPermissionGrantedEvent((Object)this, perm.getPermission(), (Project)perm.getProject(), perm.getGroup(), (StashUser)perm.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    private void grantPermission(InternalRepositoryPermission perm) {
        if (!this.repositoryPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) {
            this.repositoryPermissionDao.create((Object)perm);
            RepositoryPermissionGrantedEvent event = new RepositoryPermissionGrantedEvent((Object)this, perm.getPermission(), (Repository)perm.getRepository(), perm.getGroup(), (StashUser)perm.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void grantAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        CommonValidations.validateProject(project);
        InternalProjectPermission perm = ((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build();
        this.grantPermission(perm);
    }

    private void revokeRepositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository, @Nonnull StashUser user) {
        boolean revokeAllowed;
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedRepositoryPermission(permission, repository);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasRepositoryPermissionThroughGroupMembership(repository, permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokeownrepositorypermission", "You cannot revoke permission on {0} as it would downgrade your own permissions.", new Object[]{repository.getName()});
            throw new IntegrityException(message);
        }
        this.revokePermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
    }

    private void revokeRepositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository, @Nonnull String group) {
        boolean revokeAllowed;
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedRepositoryPermission(permission, repository);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectRepositoryUserPermission(repository, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasRepositoryPermissionThroughGroupMembership(repository, permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokegrouprepositorypermission", "You cannot revoke the permission of group {1} on {0} as it would downgrade your own permissions.", new Object[]{repository.getName(), group});
            throw new IntegrityException(message);
        }
        this.revokePermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).group(group)).build());
    }

    private boolean currentUserHasImpliedRepositoryPermission(Permission permission, final Repository repository) {
        return Iterables.any((Iterable)permission.getImplyingPermissions(), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission higherPermission) {
                if (higherPermission.isGlobal()) {
                    return PermissionAdminServiceImpl.this.permissionService.hasGlobalPermission(higherPermission);
                }
                if (higherPermission.isResource(Project.class)) {
                    return PermissionAdminServiceImpl.this.permissionService.hasProjectPermission(repository.getProject(), higherPermission);
                }
                if (higherPermission.isResource(Repository.class)) {
                    return PermissionAdminServiceImpl.this.permissionService.hasRepositoryPermission(repository, higherPermission);
                }
                return false;
            }
        });
    }

    private void revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull StashUser user) {
        boolean revokeAllowed;
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokeownprojectpermission", "You cannot revoke permission on {0} as it would downgrade your own permissions.", new Object[]{project.getName()});
            throw new IntegrityException(message);
        }
        this.revokePermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
    }

    private void revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull String group) {
        boolean revokeAllowed;
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectProjectUserPermission(project, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokegroupprojectpermission", "You cannot revoke the permission of group {1} on {0} as it would downgrade your own permissions.", new Object[]{project.getName(), group});
            throw new IntegrityException(message);
        }
        this.revokePermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).group(group)).build());
    }

    private boolean currentUserHasImpliedProjectPermission(Permission permission, final Project project) {
        return Iterables.any((Iterable)permission.getImplyingPermissions(), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission higherPermission) {
                if (higherPermission.isGlobal()) {
                    return PermissionAdminServiceImpl.this.permissionService.hasGlobalPermission(higherPermission);
                }
                if (higherPermission.isResource(Project.class)) {
                    return PermissionAdminServiceImpl.this.permissionService.hasProjectPermission(project, higherPermission);
                }
                return false;
            }
        });
    }

    private void revokeGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        boolean revokeAllowed;
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator i$ = implyingPermissions.iterator();
            while (i$.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)i$.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokeownpermission", "You cannot revoke this permission as it would downgrade your own permissions.", new Object[0]);
            throw new IntegrityException(message);
        }
        this.revokePermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
    }

    private void revokePermission(InternalGlobalPermission globalPermission) {
        if (this.globalPermissionDao.revoke((InternalGrantedPermission)globalPermission) > 0) {
            GlobalPermissionRevokedEvent event = new GlobalPermissionRevokedEvent((Object)this, globalPermission.getPermission(), globalPermission.getGroup(), (StashUser)globalPermission.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    private void revokePermission(InternalProjectPermission projectPermission) {
        if (projectPermission.getProject().getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.personalproject.revoke", "You cannot revoke project permissions on a personal project.", new Object[0]));
        }
        if (this.projectPermissionDao.revoke((InternalGrantedPermission)projectPermission) > 0) {
            ProjectPermissionRevokedEvent event = new ProjectPermissionRevokedEvent((Object)this, projectPermission.getPermission(), (Project)projectPermission.getProject(), projectPermission.getGroup(), (StashUser)projectPermission.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    private void revokePermission(InternalRepositoryPermission repositoryPermission) {
        if (this.repositoryPermissionDao.revoke((InternalGrantedPermission)repositoryPermission) > 0) {
            RepositoryPermissionRevokedEvent event = new RepositoryPermissionRevokedEvent((Object)this, repositoryPermission.getPermission(), (Repository)repositoryPermission.getRepository(), repositoryPermission.getGroup(), (StashUser)repositoryPermission.getUser());
            this.eventPublisher.publish((Object)event);
        }
    }

    private void revokeGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        boolean revokeAllowed;
        InternalStashUser currentUser = InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser());
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup((StashUser)currentUser, group);
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator i$ = implyingPermissions.iterator();
            while (i$.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)i$.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectGlobalUserPermission(permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cantrevokegrouppermission", "You cannot revoke the permission of group {0} as it would downgrade your own permissions.", new Object[]{group});
            throw new IntegrityException(message);
        }
        this.revokePermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).group(group)).build());
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        CommonValidations.validateProject(project);
        this.revokePermission(((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build());
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project) {
        CommonValidations.validateProject(project);
        if (project.getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.permissionadmin.personalproject.revokeall", "You cannot revoke all project permissions on a personal project.", new Object[0]));
        }
        this.projectPermissionDao.revokeAllForProject(project.getId().intValue());
    }

    @Transactional
    @PreAuthorize(value="not isCurrentUser(#username) and (hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN')))")
    public void revokeAllUserPermissions(@Nonnull String username) {
        CommonValidations.validateUser(username);
        StashUser user = this.userService.getUserByName(username, true);
        if (user != null) {
            this.globalPermissionDao.revokeAll(user.getId().intValue());
            this.projectPermissionDao.revokeAll(user.getId().intValue());
            this.repositoryPermissionDao.revokeAll(user.getId().intValue());
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGroupPermissions(@Nonnull String name) {
        CommonValidations.validateGroup(name);
        this.canRemovePermissionsFromGroup(name);
        this.globalPermissionDao.revokeAll(name);
        this.projectPermissionDao.revokeAll(name);
        this.repositoryPermissionDao.revokeAll(name);
    }

    private void canRemovePermissionsFromGroup(String name) {
        try {
            this.canDeleteGroup(name);
        }
        catch (IntegrityException e) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremovepermissionsgroup", "You cannot remove the permissions of this group as it would remove your own privileges.", new Object[0]);
            throw new IntegrityException(message);
        }
        catch (ForbiddenException e) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotdeletegroup", "You cannot remove the permissions of the group {0} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{name});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canRemoveUserFromGroup(@Nonnull String username, @Nonnull String group) {
        CommonValidations.validateUser(username);
        CommonValidations.validateGroup(group);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            if (!this.userService.isUserInGroup(currentUser, group)) {
                return;
            }
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremoveself", "You cannot remove yourself from this group as it would remove your own privilege.", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremoveuser", "You cannot remove {0} from the group {1} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{username, group});
            throw new ForbiddenException(message);
        }
    }

    private boolean canRemoveCurrentUserFromGroup(String group) {
        return !(this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) ? !this.permissionService.hasDirectGlobalUserPermission(Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.SYS_ADMIN, Collections.singleton(group)) : this.permissionService.hasGlobalGroupPermission(Permission.ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && !this.permissionService.hasDirectGlobalUserPermission(Permission.ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.ADMIN, Collections.singleton(group)));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canAddUserToGroup(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotaddusertogroup", "You cannot add a user to the group {0} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteGroup(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && this.userService.isUserInGroup(currentUser, group)) {
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotremovegroup", "You cannot remove this group as it would remove your own privileges.", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotdeletegroup", "You cannot remove the group {0} as it has System Administrator privileges, and you are not a System Administrator.", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteUser(@Nonnull String username) {
        CommonValidations.validateUser(username);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.selfdelete", "You cannot delete yourself.", new Object[0]);
            throw new IntegrityException(message);
        }
        StashUser user = this.userService.getUserByName(username);
        if (user == null) {
            return;
        }
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.permissionadmin.cannotdeleteuser", "You cannot delete the user {0} as they have System Administrator privileges, and you are not a System Administrator.", new Object[]{user.getName()});
            throw new ForbiddenException(message);
        }
    }

    @EventListener
    public void onGroupDeleted(GroupCleanupEvent event) {
        this.globalPermissionDao.revokeAll(event.getGroup());
        this.projectPermissionDao.revokeAll(event.getGroup());
        this.repositoryPermissionDao.revokeAll(event.getGroup());
    }

    @EventListener
    public void onUserDeleted(UserCleanupEvent event) {
        this.globalPermissionDao.revokeAll(event.getDeletedUser().getId().intValue());
        this.projectPermissionDao.revokeAll(event.getDeletedUser().getId().intValue());
        this.repositoryPermissionDao.revokeAll(event.getDeletedUser().getId().intValue());
    }

    private InternalGlobalPermission buildPermission(Permission permission, String group, StashUser user) {
        return ((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).user(InternalConverter.convertToInternalUser((StashUser)user))).group(group)).build();
    }

    @VisibleForTesting
    static Predicate<String> withoutGroups(PageProvider<String> provider) {
        return Predicates.not(new InIteratorPredicate<String>(CASE_INSENSITIVE_COMPARATOR, new PagedIterable(provider, 500).iterator()));
    }

    @VisibleForTesting
    static Predicate<StashUser> withoutUsers(PageProvider<StashUser> provider) {
        return Predicates.not(new InIteratorPredicate<StashUser>(CASE_INSENSITIVE_NAME_COMPARATOR, new PagedIterable(provider, 500).iterator()));
    }
}

