/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.auth.CaptchaResponse;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.user.CaptchaTicket;
import com.atlassian.stash.internal.user.InternalStashAuthenticationContext;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.user.AuthenticationException;
import com.atlassian.stash.user.IncorrectPasswordAuthenticationException;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.UncheckedOperation;
import com.atlassian.stash.util.UserUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserService.class)
@Service(value="userService")
public class DefaultUserService
extends AbstractService
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final InternalStashAuthenticationContext authenticationContext;
    private final CaptchaService captchaService;
    private final CrowdControl crowdControl;
    private final I18nService i18nService;
    private final PasswordResetHelper passwordResetHelper;
    private final StashUserDao userDao;
    private final UserHelper userHelper;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;
    @Value(value="${page.max.groups}")
    private int maxGroupPageSize;

    @Autowired
    public DefaultUserService(InternalStashAuthenticationContext authenticationContext, CaptchaService captchaService, CrowdControl crowdControl, I18nService i18nService, PasswordResetHelper passwordResetHelper, StashUserDao userDao, UserHelper userHelper) {
        this.authenticationContext = authenticationContext;
        this.captchaService = captchaService;
        this.crowdControl = crowdControl;
        this.i18nService = i18nService;
        this.passwordResetHelper = passwordResetHelper;
        this.userDao = userDao;
        this.userHelper = userHelper;
    }

    @Nonnull
    @Transactional(noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser authenticate(@Nonnull String username, @Nonnull String password) {
        log.debug("Authenticating user " + username);
        User crowdUser = this.crowdControl.authenticate(username, password);
        return this.getOrCreateMappedUser(crowdUser);
    }

    @Nonnull
    @Transactional(noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser authenticate(final @Nonnull String username, final @Nonnull String password, com.atlassian.stash.user.CaptchaResponse captchaResponse) {
        CaptchaResponse response = captchaResponse != null ? new CaptchaResponse(captchaResponse.getChallengeId(), captchaResponse.getUserResponse()) : null;
        CaptchaTicket token = this.captchaService.checkCaptcha(username, response);
        return this.captchaService.authenticateWithCaptcha(token, (UncheckedOperation)new UncheckedOperation<StashUser>(){

            public StashUser perform() {
                return DefaultUserService.this.authenticate(username, password);
            }
        });
    }

    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public boolean existsGroup(String groupName) {
        return this.crowdControl.findGroup(groupName) != null;
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findAllGroups(@Nonnull PageRequest pageRequest) {
        return this.findGroups(pageRequest);
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findAllUsers(@Nonnull PageRequest pageRequest) {
        return this.findUsers(pageRequest);
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findAllUsers(boolean includeDeletedUsers, @Nonnull PageRequest pageRequest) {
        return this.findUsers(pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroups(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroups(pageRequest);
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroupsByContainedText(String containedText, @Nonnull PageRequest pageRequest) {
        return this.findGroupsByName(containedText, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByName(groupName, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroupsByPrefix(@Nullable String groupPrefix, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByPrefix(groupPrefix, pageRequest);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> findGroupsByUser(@Nonnull String username, @Nonnull PageRequest pageRequest) {
        return this.crowdControl.findGroupsByUser(username, null, false, pageRequest).transform(IdentifierUtils.TO_LOWER_CASE);
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts; it is used for password resets")
    public StashUser findUserByNameOrEmail(@Nonnull String value) {
        User user = this.crowdControl.findUser(value, false);
        if (user == null) {
            user = this.crowdControl.findUserByProperty(UserTermKeys.EMAIL, (Object)value);
        }
        return user == null ? null : this.getOrCreateMappedUser(user);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.userHelper.transform(this.crowdControl.findUsers(pageRequest));
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findUsersByContainedText(String containedText, @Nonnull PageRequest pageRequest) {
        return this.findUsersByName(containedText, pageRequest);
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findUsersByContainedText(String containedText, boolean includeDeletedUsers, @Nonnull PageRequest pageRequest) {
        return this.findUsersByName(containedText, pageRequest);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<? extends StashUser> findUsersByGroup(@Nonnull String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.userHelper.transform(this.crowdControl.findUsersByGroup(groupName, null, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.userHelper.transform(this.crowdControl.findUsersByName(username, pageRequest));
    }

    @Deprecated
    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> getGroupsForUser(@Nonnull String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.findGroupsByUser(username, pageRequest);
    }

    @Deprecated
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser getUser(@Nonnull Integer id) {
        return this.getUserById(id);
    }

    @Deprecated
    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser getUser(@Nonnull String username) {
        return this.getUserByName(username);
    }

    @Deprecated
    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser getUser(@Nonnull String name, boolean returnDeletedUsers) {
        return this.getUserByName(name, returnDeletedUsers);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserById(int id) {
        return this.getUserById(id, false);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserById(int id, boolean deleted) {
        InternalStashUser user = (InternalStashUser)this.userDao.getById((Object)id);
        if (user == null) {
            return null;
        }
        return user.isCrowdBacked() || deleted ? user : null;
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserByName(@Nonnull String username) {
        return this.getUserByName(username, false);
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserByName(@Nonnull String username, boolean deleted) {
        if (this.authenticationContext.isAuthenticated() && IdentifierUtils.equalsInLowerCase((String)username, (String)this.authenticationContext.getCurrentUser().getName())) {
            return this.authenticationContext.getCurrentToken().getPrincipal();
        }
        User crowdUser = this.crowdControl.findUser(username, deleted);
        StashUser user = null;
        if (crowdUser != null) {
            user = this.getOrCreateMappedUser(crowdUser);
        } else if (deleted) {
            user = this.userDao.findByName(username);
        }
        return user;
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserBySlug(@Nonnull String userSlug) {
        if (this.authenticationContext.isAuthenticated() && this.authenticationContext.getCurrentUser().getSlug().equals(userSlug)) {
            return this.authenticationContext.getCurrentToken().getPrincipal();
        }
        return this.userDao.findBySlug(userSlug);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public Set<? extends StashUser> getUsersById(@Nonnull Set<Integer> ids) {
        return this.getUsersById(ids, false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public Set<? extends StashUser> getUsersById(@Nonnull Set<Integer> ids, boolean deleted) {
        Iterable users = this.userDao.getByIds(ids);
        if (!deleted) {
            users = Iterables.filter((Iterable)users, (Predicate)UserHelper.IS_CROWD_BACKED);
        }
        return ImmutableSet.copyOf((Iterable)users);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<? extends StashUser> getUsersByName(@Nonnull Set<String> usernames) {
        return this.getUsersByName(usernames, false);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<? extends StashUser> getUsersByName(@Nonnull Set<String> usernames, boolean deleted) {
        Set users = this.userDao.findByNames(usernames);
        if (!deleted) {
            users = ImmutableSet.copyOf((Collection)Sets.filter((Set)users, (Predicate)UserHelper.IS_CROWD_BACKED));
        }
        return users;
    }

    @Deprecated
    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> getUsersInGroup(@Nonnull String groupName, @Nonnull PageRequest pageRequest) {
        return this.findUsersByGroup(groupName, pageRequest).transform(UserUtils.TO_USERNAME);
    }

    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN') or isCurrentUser(#user)")
    public boolean isUserInGroup(@Nonnull StashUser user, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)groupName);
        InternalStashUser internalUser = InternalConverter.convertToInternalUser((StashUser)user);
        User crowdUser = internalUser.getBackingCrowdUser();
        if (crowdUser == null && (crowdUser = this.crowdControl.findUser(internalUser.getUsername(), true)) == null) {
            return false;
        }
        return this.crowdControl.isGroupMember(groupName, crowdUser);
    }

    @Unsecured(value="This is not restricted by permissions so that SAL tests pass. It should not be exposed via REST")
    public boolean isUserInGroup(@Nonnull String username, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)groupName);
        StashUser user = this.getUserByName(username);
        return user != null && this.isUserInGroup(user, groupName);
    }

    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN') or isCurrentUser(#user)")
    public boolean isUserMemberOfGroup(@Nonnull StashUser user, @Nonnull String groupName) {
        return this.isUserInGroup(user, groupName);
    }

    @Deprecated
    @Unsecured(value="This is not restricted by permissions so that SAL tests pass. It should not be exposed via REST")
    public boolean isUserMemberOfGroup(@Nonnull String username, @Nonnull String groupName) {
        return this.isUserInGroup(username, groupName);
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser preauthenticate(@Nonnull String username) {
        log.debug("Authenticating user " + username);
        StashUser user = this.getUserByName(username);
        if (user != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new StashUserAuthenticationToken(user));
        }
        return user;
    }

    @Unsecured(value="This needs to be available to all contexts")
    public void unauthenticate() {
        SecurityContextHolder.clearContext();
    }

    @Transactional
    @PreAuthorize(value="isAuthenticated()")
    public void updatePassword(@Nonnull String currentPassword, @Nonnull String newPassword) {
        String name = this.getCurrentUserForUpdate().getName();
        try {
            User user = this.crowdControl.authenticate(name, currentPassword);
            this.passwordResetHelper.resetPassword(user, newPassword);
        }
        catch (IncorrectPasswordAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.i18nService.getKeyedText("stash.service.user.password.invalid", "The current password does not match", new Object[0]));
        }
    }

    @Deprecated
    @Nonnull
    @Transactional
    @PreAuthorize(value="isAuthenticated()")
    public StashUser updateProfile(@Nonnull String displayName, @Nonnull String email) {
        return this.updateUser(displayName, email);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public StashUser updateUser(@Nonnull String displayName, @Nonnull String email) {
        Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        Preconditions.checkNotNull((Object)email, (Object)"email");
        String name = this.getCurrentUserForUpdate().getName();
        User user = this.crowdControl.updateUser(ImmutableUser.newUser().name(name).displayName(displayName).emailAddress(email).toUser());
        return this.userHelper.transform(user);
    }

    @Nonnull
    private StashUser getCurrentUserForUpdate() {
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.getKeyedText("stash.service.user.canNotUpdate.anonymous", "Please login to update your profile or password", new Object[0]));
        }
        return user;
    }

    private StashUser getOrCreateMappedUser(User crowdUser) {
        InternalStashUser user = this.userHelper.transform(crowdUser);
        if (user.getId() == null) {
            user = (InternalStashUser)this.userDao.create((Object)user);
        }
        return user;
    }
}

