/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.UserUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userHelper")
public class DefaultUserHelper
implements UserHelper {
    private final StashUserDao userDao;

    @Autowired
    public DefaultUserHelper(StashUserDao userDao) {
        this.userDao = userDao;
    }

    @Nonnull
    public InternalStashUser transform(@Nonnull User user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        InternalStashUser loaded = this.userDao.loadUser(user);
        if (loaded == null) {
            loaded = DefaultUserHelper.newStashUser(user);
        }
        return loaded;
    }

    @Nonnull
    public Page<InternalStashUser> transform(@Nonnull Page<User> page) {
        Preconditions.checkNotNull(page, (Object)"page");
        ImmutableMap stashUsers = Maps.uniqueIndex((Iterable)this.userDao.loadUsers(page.getValues()), (Function)UserUtils.TO_USERNAME);
        return page.transform((Function)new Function<User, InternalStashUser>((Map)stashUsers){
            final /* synthetic */ Map val$stashUsers;
            {
                this.val$stashUsers = map;
            }

            public InternalStashUser apply(User user) {
                InternalStashUser loaded = (InternalStashUser)this.val$stashUsers.get(UserUtils.TO_USERNAME.apply((Object)user));
                if (loaded == null) {
                    loaded = DefaultUserHelper.newStashUser(user);
                }
                return loaded;
            }
        });
    }

    private static InternalStashUser newStashUser(@Nonnull User user) {
        return new InternalStashUser.Builder().crowdUser(user).name(user.getName()).build();
    }
}

