/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.user.GroupCleanupEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.exception.InvalidTokenException;
import com.atlassian.stash.exception.MailException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.NoSuchGroupException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.user.EmailNotifier;
import com.atlassian.stash.internal.user.InternalDetailedGroup;
import com.atlassian.stash.internal.user.InternalDetailedUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.DetailedGroup;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserAdminService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserAdminService.class)
@Service(value="userAdminService")
public class DefaultUserAdminService
extends AbstractService
implements UserAdminService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAdminService.class);
    private final CrowdControl crowdControl;
    private final EmailNotifier emailNotifier;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final PasswordResetHelper passwordResetHelper;
    private final PermissionAdminService permissionAdminService;
    private final StashUserDao userDao;
    private final UserHelper userHelper;
    private final CaptchaService captchaService;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;

    @Autowired
    public DefaultUserAdminService(CrowdControl crowdControl, PermissionAdminService permissionAdminService, PasswordResetHelper passwordResetHelper, EmailNotifier emailNotifier, LicenseService licenseService, I18nService i18nService, UserHelper userHelper, EventPublisher eventPublisher, StashUserDao userDao, CaptchaService captchaService) {
        this.crowdControl = crowdControl;
        this.permissionAdminService = permissionAdminService;
        this.passwordResetHelper = passwordResetHelper;
        this.emailNotifier = emailNotifier;
        this.licenseService = licenseService;
        this.i18nService = i18nService;
        this.userHelper = userHelper;
        this.eventPublisher = eventPublisher;
        this.userDao = userDao;
        this.captchaService = captchaService;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void addUserToGroup(@Nonnull String groupName, @Nonnull String username) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.permissionAdminService.canAddUserToGroup(groupName);
        this.licenseService.validateCanAddUserToGroup(username, groupName);
        Group group = this.crowdControl.getGroup(groupName);
        User user = this.crowdControl.getUser(username);
        this.crowdControl.addGroupMember(group, user);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canUpdateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.UPDATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateUsers() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_USER);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canDeleteGroups() {
        return this.isAllowedInAnyDirectory(OperationType.DELETE_GROUP);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void clearCaptchaChallenge(@Nonnull String username) {
        this.captchaService.clearCaptchaChallenge(username);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedGroup createGroup(@Nonnull String groupName) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        this.crowdControl.createGroup((Group)new ImmutableGroup(groupName));
        return new InternalDetailedGroup.Builder().deletable(this.canDeleteGroups()).name(groupName).build();
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUser(@Nonnull String username, @Nonnull String password, @Nonnull String displayName, @Nonnull String emailAddress) {
        this.createUser(username, password, displayName, emailAddress, true);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUser(@Nonnull String username, @Nonnull String password, @Nonnull String displayName, @Nonnull String emailAddress, boolean addToDefaultGroup) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)emailAddress, (Object)"emailAddress")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)password, (Object)"password")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        User user = ImmutableUser.newUser().displayName(displayName).emailAddress(emailAddress).name(username).toUser();
        this.createUser(user, password, addToDefaultGroup);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void createUserWithGeneratedPassword(@Nonnull String username, @Nonnull String displayName, @Nonnull String emailAddress) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)emailAddress, (Object)"emailAddress")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.emailNotifier.validateCanSendEmails();
        User user = ImmutableUser.newUser().displayName(displayName).emailAddress(emailAddress).name(username).toUser();
        this.createUser(user, this.passwordResetHelper.generatePassword(), true);
        String token = this.passwordResetHelper.addResetPasswordToken(user);
        this.emailNotifier.sendCreatedUser(user, token);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedGroup deleteGroup(@Nonnull String groupName) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        this.permissionAdminService.canDeleteGroup(groupName);
        Group group = this.crowdControl.getGroup(groupName);
        this.crowdControl.deleteGroup(group);
        return new InternalDetailedGroup.Builder().deletable(false).name(groupName).build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public InternalDetailedUser deleteUser(@Nonnull String username) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.permissionAdminService.canDeleteUser(username);
        User user = this.crowdControl.getUser(username);
        this.crowdControl.deleteUser(user);
        return new InternalDetailedUser.Builder(this.userHelper.transform(user)).build();
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedGroup> findGroups(@Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroups(pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedGroup> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByName(groupName, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN') or isCurrentUser(#username)")
    public Page<DetailedGroup> findGroupsWithUser(@Nonnull String username, String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByUser(username, groupName, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedGroup> findGroupsWithoutUser(@Nonnull String username, String groupName, @Nonnull PageRequest pageRequest) {
        return this.transformGroups((Page<String>)this.crowdControl.findGroupsByUser(username, groupName, true, pageRequest));
    }

    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public InternalDetailedUser findUserByPasswordResetToken(@Nonnull String token) {
        User user = this.passwordResetHelper.findUserByResetToken(token);
        return user == null ? null : this.transformUser(user);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsers(pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsersByName(username, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedUser> findUsersWithGroup(@Nonnull String groupName, String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsersByGroup(groupName, username, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<DetailedUser> findUsersWithoutGroup(@Nonnull String groupName, String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.transformUsers((Page<User>)this.crowdControl.findUsersByGroup(groupName, username, true, pageRequest));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN') or isCurrentUser(#username)")
    public InternalDetailedUser getUserDetails(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, true);
        return user == null ? null : this.transformUser(user);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN') or isCurrentUser(#user)")
    public InternalDetailedUser getUserDetails(@Nonnull StashUser user) {
        if (user instanceof InternalStashUser) {
            return this.transformUser((InternalStashUser)user);
        }
        InternalDetailedUser detailedUser = this.getUserDetails(((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getName());
        if (detailedUser == null) {
            throw new NoSuchUserException(this.i18nService.getKeyedText("stash.service.user.nodetails", "Details are not available for %1$s; the user does not exist", new Object[]{user.getName()}), user.getName());
        }
        return detailedUser;
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent event) {
        if (this.crowdControl.findGroup(event.getGroupName()) == null) {
            this.eventPublisher.publish((Object)new GroupCleanupEvent((Object)this, event.getGroupName()));
        }
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) {
        if (this.crowdControl.findUser(event.getUsername(), true) == null) {
            InternalStashUser stashUser = this.userDao.findByName(event.getUsername());
            if (stashUser != null) {
                this.eventPublisher.publish((Object)new UserCleanupEvent((Object)this, (StashUser)stashUser));
            } else {
                log.debug("Crowd dispatched a {} for a user ({}) with no corresponding {} and was ignored.", new Object[]{UserDeletedEvent.class.getSimpleName(), StashUser.class.getSimpleName(), event.getUsername()});
            }
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void removeUserFromGroup(@Nonnull String groupName, @Nonnull String username) {
        Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        this.permissionAdminService.canRemoveUserFromGroup(username, groupName);
        Group group = this.crowdControl.getGroup(groupName);
        User user = this.crowdControl.getUser(username);
        if (!this.crowdControl.removeGroupMember(group, user)) {
            Directory directory = this.crowdControl.findDirectoryFor(user);
            String directoryName = directory == null ? "<Unknown>" : directory.getName();
            log.info(String.format("Failed to remove user %1$s from group %2$s. Group %2$s may not exist in the same directory as the primary user with name %1$s. The 'primary' user is the first user with that name resolved from the ordered list of User Directories.", username, groupName));
            throw new NoSuchGroupException(this.i18nService.getKeyedText("stash.service.remoteUserFromGroup.notFromGroup", "The user {0} from directory {1} does not belong to the {2} group in that directory, so they cannot be removed from it. This user may be shadowed by a user with the same name in another directory.", new Object[]{username, directoryName, groupName}), groupName);
        }
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#currentUsername, 'SYS_ADMIN'))")
    public DetailedUser renameUser(@Nonnull String currentUsername, @Nonnull String newUsername) {
        Preconditions.checkNotNull((Object)currentUsername, (Object)"currentUserName");
        Preconditions.checkNotNull((Object)newUsername, (Object)"newUserName");
        User user = this.crowdControl.getUser(currentUsername);
        user = this.crowdControl.renameUser(user, newUsername);
        return this.transformUser(user);
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void requestPasswordReset(@Nonnull String username) throws NoSuchEntityException, MailException {
        User user = this.crowdControl.getUser(username);
        this.emailNotifier.sendPasswordReset(user, this.passwordResetHelper.addResetPasswordToken(user));
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void resetPassword(@Nonnull String token, @Nonnull String password) {
        Preconditions.checkNotNull((Object)token, (Object)"token");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)password, (Object)"password")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        User user = this.passwordResetHelper.findUserByResetToken(token);
        if (user == null) {
            throw new InvalidTokenException(this.i18nService.getKeyedText("stash.service.invalidtoken", "Invalid token", new Object[0]), token);
        }
        this.passwordResetHelper.resetPassword(user, password);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void updatePassword(@Nonnull String username, @Nonnull String newPassword) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)newPassword, (Object)"newPassword")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        this.passwordResetHelper.resetPassword(this.crowdControl.getUser(username), newPassword);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public InternalDetailedUser updateUser(@Nonnull String username, @Nonnull String displayName, @Nonnull String emailAddress) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank display name is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)emailAddress, (Object)"emailAddress")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank e-mail address is required");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        User user = this.crowdControl.getUser(username);
        user = this.crowdControl.updateUser(ImmutableUser.newUser((User)user).displayName(displayName).emailAddress(emailAddress).toUser());
        return this.transformUser(user);
    }

    private void addToGroupIfExisting(User user, String groupName) {
        Group group = this.crowdControl.findGroup(groupName);
        if (group != null) {
            this.licenseService.validateCanAddUserToGroup(user.getName(), groupName);
            this.crowdControl.addGroupMember(group, user);
        }
    }

    private void createUser(User user, String password, boolean addToDefaultGroup) {
        this.crowdControl.createUser(user, password);
        if (addToDefaultGroup) {
            this.addToGroupIfExisting(user, "stash-users");
        }
    }

    private boolean isAllowedInAnyDirectory(OperationType type) {
        List directories = this.crowdControl.listDirectories();
        for (Directory directory : directories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(type)) continue;
            return true;
        }
        return false;
    }

    private Page<DetailedGroup> transformGroups(Page<String> page) {
        return page.transform((Function)new DetailedGroupTransform(this.canDeleteGroups()));
    }

    private InternalDetailedUser transformUser(User user) {
        return this.transformUser(this.userHelper.transform(user));
    }

    private InternalDetailedUser transformUser(InternalStashUser user) {
        InternalDetailedUser.Builder builder = new InternalDetailedUser.Builder(user);
        Directory directory = this.crowdControl.findDirectoryFor(user.getBackingCrowdUser());
        if (directory != null) {
            Set operations = directory.getAllowedOperations();
            builder.directoryName(directory.getName()).mutableDetails(operations.contains(OperationType.UPDATE_USER)).mutableGroups(operations.contains(OperationType.UPDATE_GROUP));
        }
        return builder.build();
    }

    private Page<DetailedUser> transformUsers(Page<User> page) {
        return this.userHelper.transform(page).transform((Function)new DetailedUserTransform());
    }

    private class DetailedUserTransform
    implements Function<InternalStashUser, DetailedUser> {
        private DetailedUserTransform() {
        }

        public DetailedUser apply(InternalStashUser user) {
            return DefaultUserAdminService.this.transformUser(user);
        }
    }

    private static class DetailedGroupTransform
    implements Function<String, DetailedGroup> {
        private final InternalDetailedGroup.Builder builder;

        private DetailedGroupTransform(boolean deletable) {
            this.builder = new InternalDetailedGroup.Builder().deletable(deletable);
        }

        public DetailedGroup apply(String group) {
            return this.builder.name(group).build();
        }
    }
}

