/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.exception.NoMailHostConfigurationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.mail.InternalMailService;
import com.atlassian.stash.internal.user.EmailNotifier;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="emailNotifier")
public class DefaultEmailNotifier
implements EmailNotifier {
    public static final String SOY_EMAIL_TEMPLATE_MODULE = "com.atlassian.stash.stash-web-plugin:server-soy-templates";
    public static final String TEMPLATE_EMAIL_CREATE_USER = "stash.email.plaintext.userCreatedWithoutPassword";
    public static final String TEMPLATE_EMAIL_RESET_USER_PASSWORD = "stash.email.plaintext.userResetPassword";
    private final InternalMailService mailService;
    private final ApplicationPropertiesService propertiesService;
    private final I18nService i18nService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final StashAuthenticationContext authenticationContext;

    @Autowired
    public DefaultEmailNotifier(InternalMailService mailService, ApplicationPropertiesService propertiesService, I18nService i18nService, SoyTemplateRenderer soyTemplateRenderer, StashAuthenticationContext authenticationContext) {
        this.mailService = mailService;
        this.propertiesService = propertiesService;
        this.i18nService = i18nService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public void validateCanSendEmails() {
        if (!this.mailService.isHostConfigured()) {
            throw new NoMailHostConfigurationException(this.i18nService.getKeyedText("stash.service.cant.send.emails", "Can''t send an email notification: no mail server configuration is defined", new Object[0]));
        }
    }

    @Override
    public void sendCreatedUser(User user, String token) {
        this.validateCanSendEmails();
        String subject = this.i18nService.getText("stash.notification.welcome.subject", "Welcome to {0}", new Object[]{this.propertiesService.getDisplayName()});
        String text = this.renderText(TEMPLATE_EMAIL_CREATE_USER, (Map<String, Object>)ImmutableMap.of((Object)"invitingUser", (Object)this.authenticationContext.getCurrentUser(), (Object)"newUser", (Object)user, (Object)"token", (Object)token));
        this.send(user, subject, text);
    }

    @Override
    public void sendPasswordReset(User user, String token) {
        this.validateCanSendEmails();
        String subject = this.i18nService.getText("stash.notification.reset.password", "Password reset request for {0}", new Object[]{user.getDisplayName()});
        String text = this.renderText(TEMPLATE_EMAIL_RESET_USER_PASSWORD, (Map<String, Object>)ImmutableMap.of((Object)"date", (Object)FastDateFormat.getTimeInstance((int)3).format(new Date()), (Object)"user", (Object)user, (Object)"token", (Object)token));
        this.send(user, subject, text);
    }

    private void send(User user, String subject, String text) {
        this.mailService.sendNow(new MailMessage.Builder().to(new String[]{user.getEmailAddress()}).text(text).subject(subject).build());
    }

    private String renderText(String template, Map<String, Object> data) {
        try {
            return this.soyTemplateRenderer.render(SOY_EMAIL_TEMPLATE_MODULE, template, data);
        }
        catch (SoyException e) {
            throw new IllegalStateException("Error rendering email body", e);
        }
    }
}

