/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.ProjectDeletedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.event.permission.PermissionEvent;
import com.atlassian.stash.event.permission.ProjectPermissionEvent;
import com.atlassian.stash.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.stash.event.user.GroupCleanupEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.GrantedPermissionSet;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.internal.user.PermissionGraphFactory;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="permissionGraphFactory")
public class CachingPermissionGraphFactory
implements PermissionGraphFactory {
    private volatile GrantedPermissionSet defaultPermissions;
    private final EffectivePermissionDao effectivePermissionDao;
    private final Cache<String, GrantedPermissionSet> groupPermissions;
    private int maxGrantedPermissionsPageSize;
    private final ProjectPermissionDao projectPermissionDao;
    private final TransactionTemplate transactionTemplate;
    private final Cache<Integer, GrantedPermissionSet> userPermissions;
    private final UserService userService;

    @Autowired
    public CachingPermissionGraphFactory(final EffectivePermissionDao effectivePermissionDao, ProjectPermissionDao projectPermissionDao, PlatformTransactionManager transactionManager, UserService userService, @Value(value="${permissions.cache.groups.max}") int maxCachedGroupPermissions, @Value(value="${permissions.cache.users.max}") int maxCachedUserPermissions) {
        this.effectivePermissionDao = effectivePermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.userService = userService;
        this.maxGrantedPermissionsPageSize = 1000;
        this.groupPermissions = CacheBuilder.newBuilder().maximumSize(maxCachedGroupPermissions).build((CacheLoader)new CacheLoader<String, GrantedPermissionSet>(){

            public GrantedPermissionSet load(String key) throws Exception {
                throw new UnsupportedOperationException("Unexpected use of cache loader for group permissions");
            }
        });
        this.userPermissions = CacheBuilder.newBuilder().maximumSize(maxCachedUserPermissions).build((CacheLoader)new CacheLoader<Integer, GrantedPermissionSet>(){

            public GrantedPermissionSet load(final Integer key) throws Exception {
                return new GrantedPermissionSet.Builder().addAll((Iterable<? extends InternalGrantedPermission>)new PagedIterable((PageProvider)new PageProvider<InternalGrantedPermission>(){

                    public Page<InternalGrantedPermission> get(PageRequest request) {
                        return effectivePermissionDao.findByUserId(key, request);
                    }
                }, CachingPermissionGraphFactory.this.maxGrantedPermissionsPageSize)).build();
            }
        });
    }

    @Nonnull
    public PermissionGraph createGraph(@Nonnull StashUser user) {
        return new GrantedPermissionSet.Builder().addAll(this.defaultPermissions).addAll(this.getGroupsPermissions(this.getGroups(user))).addAll(this.getUserPermissions(user.getId())).build();
    }

    @PostConstruct
    public void initialize() {
        this.defaultPermissions = (GrantedPermissionSet)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<GrantedPermissionSet>(){

            public GrantedPermissionSet doInTransaction(TransactionStatus transactionStatus) {
                PagedIterable defaultPermissions = new PagedIterable((PageProvider)new PageProvider<InternalProjectPermission>(){

                    public Page<InternalProjectPermission> get(PageRequest request) {
                        return CachingPermissionGraphFactory.this.projectPermissionDao.findDefaultPermissions(request);
                    }
                }, CachingPermissionGraphFactory.this.maxGrantedPermissionsPageSize);
                return new GrantedPermissionSet.Builder().addAll((Iterable<? extends InternalGrantedPermission>)defaultPermissions).build();
            }
        });
    }

    @EventListener
    public void onGroupCleanup(GroupCleanupEvent event) {
        this.groupPermissions.invalidate((Object)event.getGroup());
    }

    @EventListener
    public void onPermissionsChanged(PermissionEvent event) {
        StashUser user = event.getAffectedUser();
        String group = event.getAffectedGroup();
        if (user != null) {
            this.userPermissions.invalidate((Object)user.getId());
        } else if (StringUtils.isNotBlank((String)group)) {
            this.groupPermissions.invalidate((Object)group);
        } else if (event instanceof ProjectPermissionEvent) {
            this.updateDefaultPermission(((ProjectPermissionEvent)event).getProject(), event instanceof ProjectPermissionGrantedEvent ? event.getPermission() : null);
        }
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.updateDefaultPermission(event.getProject(), null);
        this.userPermissions.invalidateAll();
        this.groupPermissions.invalidateAll();
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.userPermissions.invalidateAll();
        this.groupPermissions.invalidateAll();
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        StashUser deletedUser = event.getDeletedUser();
        if (deletedUser != null) {
            this.userPermissions.invalidate((Object)deletedUser.getId());
        }
    }

    @Value(value="${page.max.granted.permissions}")
    public void setMaxGrantedPermissionsPageSize(int maxGrantedPermissionsPageSize) {
        this.maxGrantedPermissionsPageSize = maxGrantedPermissionsPageSize;
    }

    private PageRequest createPage1Request() {
        return PageUtils.newRequest((int)0, (int)this.maxGrantedPermissionsPageSize);
    }

    private Iterable<String> getGroups(final StashUser user) {
        return new PagedIterable((PageProvider)new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return CachingPermissionGraphFactory.this.userService.findGroupsByUser(user.getName(), request);
            }
        }, this.createPage1Request());
    }

    private GrantedPermissionSet getGroupsPermissions(Iterable<String> groups) {
        ConcurrentMap groupPermissionsMap = this.groupPermissions.asMap();
        GrantedPermissionSet.Builder builder = new GrantedPermissionSet.Builder();
        final HashSet missingGroups = Sets.newHashSet();
        for (String group : groups) {
            GrantedPermissionSet groupPerms = (GrantedPermissionSet)groupPermissionsMap.get(group);
            if (groupPerms != null) {
                builder.addAll(groupPerms);
                continue;
            }
            missingGroups.add(group);
        }
        if (!missingGroups.isEmpty()) {
            String curGroup = null;
            GrantedPermissionSet.Builder groupPermBuilder = null;
            PagedIterable permissions = new PagedIterable((PageProvider)new PageProvider<InternalGrantedPermission>(){

                public Page<InternalGrantedPermission> get(PageRequest request) {
                    return CachingPermissionGraphFactory.this.effectivePermissionDao.findByGroup((Iterable)missingGroups, request);
                }
            }, this.maxGrantedPermissionsPageSize);
            for (InternalGrantedPermission permission : permissions) {
                if (!permission.getGroup().equals(curGroup)) {
                    if (groupPermBuilder != null) {
                        groupPermissionsMap.put(curGroup, groupPermBuilder.build());
                    }
                    curGroup = permission.getGroup();
                    groupPermBuilder = new GrantedPermissionSet.Builder();
                }
                builder.add(permission);
                groupPermBuilder.add(permission);
            }
            if (groupPermBuilder != null) {
                groupPermissionsMap.put(curGroup, groupPermBuilder.build());
            }
        }
        return builder.build();
    }

    private GrantedPermissionSet getUserPermissions(Integer userId) {
        return (GrantedPermissionSet)this.userPermissions.getUnchecked((Object)userId);
    }

    private synchronized void updateDefaultPermission(Project project, Permission newPermission) {
        GrantedPermissionSet.Builder builder = new GrantedPermissionSet.Builder().addAll(this.defaultPermissions).clearAll(project);
        if (newPermission != null) {
            builder.add(newPermission, project.getId());
        }
        this.defaultPermissions = builder.build();
    }
}

