/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class SemaphoreTicketBucket {
    private final long defaultAcquireTimeoutMillis;
    private final int permits;
    private final Semaphore semaphore;
    private volatile long lastRejectedTimestamp = 0L;
    private final ConcurrentSkipListSet<Timing> timings;

    public SemaphoreTicketBucket(int permits, long defaultAcquireTimeout, @Nonnull TimeUnit unit) {
        this.defaultAcquireTimeoutMillis = Math.max(0L, unit.toMillis(defaultAcquireTimeout));
        this.permits = permits;
        this.semaphore = new Semaphore(permits, defaultAcquireTimeout > 0L);
        this.timings = new ConcurrentSkipListSet();
    }

    public long getLastRejectedTimestamp() {
        return this.lastRejectedTimestamp;
    }

    public int getNumberOfPermits() {
        return this.permits;
    }

    public void release() {
        this.semaphore.release();
    }

    public boolean tryAcquireTicket() {
        return this.tryAcquireTicket(this.defaultAcquireTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquireTicket(long timeout, TimeUnit timeUnit) {
        boolean acquired = false;
        Timing timing = new Timing();
        this.timings.add(timing);
        try {
            acquired = this.semaphore.tryAcquire(timeout, timeUnit);
        }
        catch (InterruptedException e) {
        }
        finally {
            this.timings.remove(timing);
        }
        if (!acquired) {
            this.lastRejectedTimestamp = System.currentTimeMillis();
        }
        return acquired;
    }

    public long getEarliestQueuingTime() {
        if (this.timings.isEmpty()) {
            return 0L;
        }
        try {
            Long earliestTiming = this.timings.first().start;
            return earliestTiming;
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    private static class Timing
    implements Comparable<Timing> {
        private final long start = System.currentTimeMillis();

        private Timing() {
        }

        @Override
        public int compareTo(Timing o) {
            return (int)(this.start - o.start);
        }
    }
}

