/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.internal.server.ServerBusyMonitor;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="serverBusyMonitor")
public class DefaultServerBusyMonitor
implements ServerBusyMonitor {
    private final InternalThrottleService internalThrottleService;
    private long resourceBusyMessageTimeout;
    private long serverBusyQueueTime;
    private long serverBusyMessageTimeout;
    private Iterable<String> resourceNames;

    @Autowired
    public DefaultServerBusyMonitor(InternalThrottleService throttleService) {
        this.internalThrottleService = throttleService;
        this.resourceNames = Collections.singleton("scm-hosting");
    }

    public boolean isQueueingRequests() {
        if (this.serverBusyQueueTime < 1L) {
            return false;
        }
        long longestQueuingTime = 0L;
        for (String resource : this.resourceNames) {
            long resourceTime = this.internalThrottleService.getLongestQueueingTimeForCurrentTicketRequests(resource);
            if (resourceTime <= longestQueuingTime) continue;
            longestQueuingTime = resourceTime;
        }
        if (longestQueuingTime == 0L) {
            return false;
        }
        return longestQueuingTime > this.serverBusyQueueTime;
    }

    public boolean hasRecentlyRejectedRequests() {
        if (this.resourceBusyMessageTimeout < 1L && this.serverBusyMessageTimeout < 1L) {
            return false;
        }
        long timeSinceLastRejection = 0L;
        for (String resource : this.resourceNames) {
            long resourceTime = this.internalThrottleService.getTimeSinceLastRejectedTicketRequest(resource);
            if (resourceTime <= timeSinceLastRejection) continue;
            timeSinceLastRejection = resourceTime;
        }
        if (timeSinceLastRejection == 0L) {
            return false;
        }
        long timeout = this.serverBusyMessageTimeout > 0L ? this.serverBusyMessageTimeout : this.resourceBusyMessageTimeout;
        return timeSinceLastRejection < timeout;
    }

    @Value(value="${server.busy.on.queue.time}")
    public void setServerBusyQueueTime(long serverBusyQueueTime) {
        this.setServerBusyQueueTime(serverBusyQueueTime, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    void setServerBusyQueueTime(long serverBusyQueueTime, TimeUnit timeUnit) {
        this.serverBusyQueueTime = timeUnit.toMillis(serverBusyQueueTime);
    }

    @Deprecated
    @Value(value="${throttle.resource.busy.message.timeout}")
    public void setResourceBusyMessageTimeout(long resourceBusyMessageTimeout) {
        this.resourceBusyMessageTimeout = TimeUnit.MINUTES.toMillis(resourceBusyMessageTimeout);
    }

    @Value(value="${server.busy.on.ticket.rejected.within}")
    public void setServerBusyMessageTimeout(long resourceBusyMessageTimeout) {
        this.serverBusyMessageTimeout = TimeUnit.MINUTES.toMillis(resourceBusyMessageTimeout);
    }
}

