/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.internal.server.ProfilingService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="profilingService")
public class DefaultProfilingService
implements ProfilingService {
    private final ApplicationPropertiesService applicationPropertiesService;

    @Autowired
    public DefaultProfilingService(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    public void disable() {
        UtilTimerStack.setActive((boolean)false);
    }

    public void enable() {
        UtilTimerStack.setActive((boolean)true);
        UtilTimerStack.setMinTotalTime((long)0L);
    }

    public void enable(int profilingThreshold) {
        UtilTimerStack.setActive((boolean)true);
        UtilTimerStack.setMinTotalTime((long)profilingThreshold);
    }

    public boolean isEnabled() {
        return UtilTimerStack.isActive();
    }

    @PostConstruct
    protected void onStartup() {
        if (this.applicationPropertiesService.isProfilingEnabled()) {
            this.enable();
        }
    }
}

