/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.stash.content.Blame;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.ContentTreeCallback;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.DetailedChangeset;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.FileContentCallback;
import com.atlassian.stash.io.TypeAwareOutputSupplier;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefCallback;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.Tag;
import com.atlassian.stash.scm.BlameCommandParameters;
import com.atlassian.stash.scm.BranchesCommandParameters;
import com.atlassian.stash.scm.ChangesCommandParameters;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.CommitCommandParameters;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.DetailedCommitsCommandParameters;
import com.atlassian.stash.scm.DiffCommandParameters;
import com.atlassian.stash.scm.DirectoryCommandParameters;
import com.atlassian.stash.scm.FileCommandParameters;
import com.atlassian.stash.scm.MergeCommandParameters;
import com.atlassian.stash.scm.PluginCommandFactory;
import com.atlassian.stash.scm.RawFileCommandParameters;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.TagsCommandParameters;
import com.atlassian.stash.scm.TypeCommandParameters;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;

public class PluginScmCommandFactory
implements ScmCommandFactory {
    private final PluginCommandFactory commandFactory;
    private final Repository repository;

    public PluginScmCommandFactory(Repository repository, PluginCommandFactory commandFactory) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.commandFactory = (PluginCommandFactory)Preconditions.checkNotNull((Object)commandFactory, (Object)"commandFactory");
    }

    @Nonnull
    public Command<List<Blame>> blame(@Nonnull BlameCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.blame(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Page<Branch>> branches(@Nonnull BranchesCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.branches(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Page<Change>> changes(@Nonnull ChangesCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.changes(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Changeset> commit(@Nonnull CommitCommandParameters parameters) {
        return this.commandFactory.commit(this.repository, parameters);
    }

    @Nonnull
    public Command<Page<Changeset>> commits(@Nonnull CommitsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.commits(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull CommitsCommandParameters parameters, @Nonnull ChangesetCallback callback) {
        return this.commandFactory.commits(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Void> create() {
        return this.commandFactory.create(this.repository);
    }

    @Nonnull
    public Command<Branch> defaultBranch() {
        return this.commandFactory.defaultBranch(this.repository);
    }

    @Deprecated
    @Nonnull
    public Command<Void> deleteBranch(@Nonnull String branch) {
        return this.commandFactory.deleteBranch(this.repository, branch);
    }

    @Nonnull
    public Command<Page<DetailedChangeset>> detailedCommits(@Nonnull DetailedCommitsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.detailedCommits(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull DiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Void> directory(@Nonnull DirectoryCommandParameters parameters, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.directory(this.repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public Command<Void> file(@Nonnull FileCommandParameters parameters, @Nonnull FileContentCallback callback, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.file(this.repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public Command<Void> fork(@Nonnull Repository fork) {
        return this.commandFactory.fork(this.repository, fork);
    }

    @Nonnull
    public Command<Void> heads(@Nonnull RefCallback callback) {
        return this.commandFactory.heads(this.repository, callback);
    }

    @Nonnull
    public Command<Branch> merge(@Nonnull MergeCommandParameters parameters) {
        return this.commandFactory.merge(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> rawFile(@Nonnull RawFileCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        return this.commandFactory.rawFile(this.repository, parameters, outputSupplier);
    }

    @Deprecated
    @Nonnull
    public Command<Void> reparent(@Nonnull Repository newParent) {
        return this.commandFactory.reparent(this.repository, newParent);
    }

    @Nonnull
    public Command<Ref> resolveRef(@Nonnull String refId) {
        return this.commandFactory.resolveRef(this.repository, refId);
    }

    @Nonnull
    public Command<Page<Tag>> tags(@Nonnull TagsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.tags(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<ContentTreeNode.Type> type(@Nonnull TypeCommandParameters parameters) {
        return this.commandFactory.type(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> updateDefaultBranch(@Nonnull String branchName) throws IllegalArgumentException, UnsupportedOperationException {
        return this.commandFactory.updateDefaultBranch(this.repository, branchName);
    }
}

