/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.request.RequestEndedEvent;
import com.atlassian.stash.event.request.RequestStartedEvent;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.logback.LoggingConstants;
import com.atlassian.stash.internal.request.DefaultRequestContext;
import com.atlassian.stash.internal.request.DefaultRequestMetadata;
import com.atlassian.stash.request.RequestCallback;
import com.atlassian.stash.request.RequestContext;
import com.atlassian.stash.request.RequestInfoProvider;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.request.RequestMetadata;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=RequestManager.class)
@Component(value="requestManager")
public class DefaultRequestManager
implements RequestManager,
StatefulService {
    private static final Logger accessLog = LoggerFactory.getLogger((String)LoggingConstants.LOGGER_ACCESS);
    private final StashAuthenticationContext authenticationContext;
    private final AtomicLong concurrentCounter;
    private final AtomicLong requestCounter;
    private final EventPublisher eventPublisher;
    private final ThreadLocal<DefaultRequestContext> currentRequestContext;
    private final ThreadLocal<RequestMetadata> requestMetadata;

    @Autowired
    public DefaultRequestManager(StashAuthenticationContext authenticationContext, EventPublisher eventPublisher) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.concurrentCounter = new AtomicLong(0L);
        this.requestCounter = new AtomicLong(0L);
        this.currentRequestContext = new ThreadLocal();
        this.requestMetadata = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T, E extends Exception> T doAsRequest(@Nonnull RequestCallback<T, E> callback, @Nonnull RequestInfoProvider requestInfoProvider) throws E {
        if (this.currentRequestContext.get() == null) {
            Timer timer;
            long startTime = System.currentTimeMillis();
            DefaultRequestContext requestInfo = new DefaultRequestContext(this.authenticationContext, requestInfoProvider, this.generateRequestId());
            this.concurrentCounter.incrementAndGet();
            this.currentRequestContext.set(requestInfo);
            this.logStartRequest(requestInfo);
            this.eventPublisher.publish((Object)new RequestStartedEvent((Object)this, (RequestContext)requestInfo));
            if (TimerUtils.isActive()) {
                String action = requestInfo.getAction();
                timer = TimerUtils.start((String)action);
                Object object = callback.withRequest((RequestContext)requestInfo);
                return (T)object;
            }
            Object object = callback.withRequest((RequestContext)requestInfo);
            return (T)object;
            {
                finally {
                    timer.stop();
                }
            }
            finally {
                this.concurrentCounter.decrementAndGet();
                this.currentRequestContext.remove();
                try {
                    this.eventPublisher.publish((Object)new RequestEndedEvent((Object)this, (RequestContext)requestInfo));
                }
                finally {
                    this.logEndRequest(requestInfo, System.currentTimeMillis() - startTime);
                    MDC.clear();
                }
            }
        }
        return (T)callback.withRequest((RequestContext)this.currentRequestContext.get());
    }

    @Nullable
    public RequestContext getRequestContext() {
        return this.currentRequestContext.get();
    }

    @Nullable
    public RequestMetadata getRequestMetadata() {
        RequestMetadata md = this.requestMetadata.get();
        if (md == null) {
            return this.getRequestContext();
        }
        return md;
    }

    protected String generateRequestId() {
        long count = this.requestCounter.incrementAndGet();
        return new DateTime().getMinuteOfDay() + "x" + count + "x" + this.concurrentCounter.get();
    }

    protected void setupMDC(DefaultRequestContext requestContext) {
        MDC.put((String)"a-request-id", (String)requestContext.getId());
        MDC.put((String)"a-remote-address", (String)requestContext.getRemoteAddress());
        MDC.put((String)"a-request-details", (String)requestContext.getDetails());
        MDC.put((String)"a-session-id", (String)requestContext.getSessionId());
        MDC.put((String)"a-protocol", (String)requestContext.getProtocol());
        MDC.put((String)"a-request-action", (String)requestContext.getAction());
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            MDC.put((String)"a-username", (String)user.getName());
        }
    }

    protected void logStartRequest(DefaultRequestContext requestInfo) {
        this.setupMDC(requestInfo);
        MDC.put((String)"a-in-out", (String)"i");
        accessLog.info("");
    }

    protected void logEndRequest(DefaultRequestContext requestInfo, long requestTime) {
        this.setupMDC(requestInfo);
        MDC.put((String)"a-request-time", (String)Long.toString(requestTime));
        MDC.put((String)"a-in-out", (String)"o");
        accessLog.info("");
    }

    @Nonnull
    public TransferableState getState() {
        return new RequestMetadataState(this.getRequestMetadata());
    }

    private final class RequestMetadataState
    implements TransferableState {
        private final RequestMetadata metadata;

        public RequestMetadataState(RequestMetadata md) {
            this.metadata = md != null ? new DefaultRequestMetadata(md) : null;
        }

        public void apply() {
            DefaultRequestManager.this.requestMetadata.set(this.metadata);
        }

        public void remove() {
            DefaultRequestManager.this.requestMetadata.remove();
        }
    }
}

