/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.stash.request.RequestContext;
import com.atlassian.stash.request.RequestInfoProvider;
import com.atlassian.stash.user.StashAuthenticationContext;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

class DefaultRequestContext
implements RequestContext {
    private final StashAuthenticationContext authenticationContext;
    private final RequestInfoProvider delegate;
    private final SortedSet<String> labels;
    private final String id;

    DefaultRequestContext(StashAuthenticationContext authenticationContext, RequestInfoProvider delegate, String id) {
        this.authenticationContext = authenticationContext;
        this.delegate = delegate;
        this.id = id;
        this.labels = new TreeSet<String>();
    }

    public void addLabel(@Nonnull String label) {
        this.labels.add(label);
        MDC.put((String)"a-request-labels", (String)StringUtils.join(this.labels, (String)", "));
    }

    @Nonnull
    public String getAction() {
        return this.delegate.getAction();
    }

    public StashAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public String getDetails() {
        return this.delegate.getDetails();
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    @Nonnull
    public Object getRawRequest() {
        return this.delegate.getRawRequest();
    }

    @Nonnull
    public Object getRawResponse() {
        return this.delegate.getRawResponse();
    }

    public String getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    public String getSessionId() {
        return this.delegate.getSessionId();
    }

    public boolean hasSessionId() {
        return this.delegate.hasSessionId();
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }
}

