/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.event.RepositoryCreatedEvent;
import com.atlassian.stash.event.RepositoryCreationFailedEvent;
import com.atlassian.stash.event.RepositoryCreationRequestedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.event.RepositoryDeletionRequestedEvent;
import com.atlassian.stash.event.RepositoryForkFailedEvent;
import com.atlassian.stash.event.RepositoryForkRequestedEvent;
import com.atlassian.stash.event.RepositoryForkedEvent;
import com.atlassian.stash.event.RepositoryModificationRequestedEvent;
import com.atlassian.stash.event.RepositoryModifiedEvent;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.NoSuchProjectException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.util.ValidationUtils;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.AbstractRepositoryRequest;
import com.atlassian.stash.repository.ForkingDisabledException;
import com.atlassian.stash.repository.IllegalRepositoryStateException;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryCreateRequest;
import com.atlassian.stash.repository.RepositoryCreationCanceledException;
import com.atlassian.stash.repository.RepositoryDeletionCanceledException;
import com.atlassian.stash.repository.RepositoryForkCanceledException;
import com.atlassian.stash.repository.RepositoryForkRequest;
import com.atlassian.stash.repository.RepositoryModificationCanceledException;
import com.atlassian.stash.repository.RepositorySearchRequest;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.repository.RepositoryUpdateRequest;
import com.atlassian.stash.repository.RepositoryVisibility;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.DeleteCommandParameters;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.SimpleCancelState;
import com.atlassian.stash.validation.groups.Create;
import com.atlassian.stash.validation.groups.Update;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=RepositoryService.class)
@Service(value="repositoryService")
public class RepositoryServiceImpl
extends AbstractService
implements InternalRepositoryService {
    private static final int MINIMUM_MAX_REPOSITORIES = 50;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final PermissionPredicateFactory predicateFactory;
    private final InternalPermissionService permissionService;
    private final InternalProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final RepositoryDao repositoryDao;
    private final InternalScmService scmService;
    private final SecureTokenGenerator tokenGenerator;
    private final TransactionTemplate transactionTemplate;
    private final Validator validator;
    private int maxRepositoriesPerPage;

    @Autowired
    public RepositoryServiceImpl(EventPublisher eventPublisher, ScheduledExecutorService executorService, FeatureManager featureManager, I18nService i18nService, PermissionPredicateFactory predicateFactory, InternalPermissionService permissionService, InternalProjectService projectService, ApplicationPropertiesService propertiesService, RepositoryDao repositoryDao, InternalScmService scmService, SecureTokenGenerator tokenGenerator, PlatformTransactionManager transactionManager, Validator validator) {
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.repositoryDao = repositoryDao;
        this.scmService = scmService;
        this.tokenGenerator = tokenGenerator;
        this.validator = validator;
        this.maxRepositoriesPerPage = 50;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Secured(value="by the delegated method")
    @Transactional(readOnly=true)
    public int countByProject(@Nonnull Project project) {
        return this.permissionService.getCountOfAccessibleRepositories(project);
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository create(@Nonnull Project project, @Nonnull String name, @Nonnull String scmId) {
        return this.create(((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().name(name)).project(project).scmId(scmId).build());
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository create(@Nonnull RepositoryCreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalRepository repository = this.createRepositoryInDatabase((AbstractRepositoryRequest)request, request.getProject(), request.getScmId(), null, true);
        this.createRepositoryInScm(repository);
        return repository;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public void delete(@Nonnull Repository repository) {
        if (((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getState() != Repository.State.AVAILABLE) {
            throw new IllegalRepositoryStateException(this.i18nService.getKeyedText("stash.service.repository.delete.invalidstate", "You cannot delete {0}/{1}; only {2} repositories may be deleted. (Current state: {3})", new Object[]{repository.getProject().getKey(), repository.getSlug(), Repository.State.AVAILABLE, repository.getState()}));
        }
        final InternalRepository internal = InternalConverter.convertToInternalRepository((Repository)repository);
        final Iterable forkIds = (Iterable)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Iterable<Integer>>(){

            public Iterable<Integer> doInTransaction(TransactionStatus transactionStatus) {
                RepositoryServiceImpl.this.fireRepositoryDeletionRequested((Repository)internal);
                return RepositoryServiceImpl.this.deleteInDatabase(internal);
            }
        });
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                long count;
                DeleteCommandParameters.Builder builder = new DeleteCommandParameters.Builder().forkIds(forkIds);
                if (Iterables.isEmpty((Iterable)forkIds) && (count = ((Long)RepositoryServiceImpl.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Long>(){

                    public Long doInTransaction(TransactionStatus status) {
                        status.setRollbackOnly();
                        return RepositoryServiceImpl.this.repositoryDao.countByHierarchy(internal.getHierarchyId());
                    }
                })).longValue()) == 0L) {
                    builder.lastInHierarchy();
                }
                RepositoryServiceImpl.this.scmService.delete((Repository)internal, builder.build());
            }
        });
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<InternalRepository> findAll(@Nonnull PageRequest pageRequest) {
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return this.repositoryDao.findAll(pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Deprecated
    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository findById(@Nonnull Integer id) {
        return this.getById(id);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#origin)")
    public Page<InternalRepository> findByOrigin(@Nonnull Repository origin, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)origin, (Object)"origin");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return this.repositoryDao.findByOrigin(InternalConverter.convertToInternalRepository((Repository)origin), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<InternalRepository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest) throws NoSuchProjectException {
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (this.projectService.getByKey(projectKey) == null) {
            if (InternalPersonalProject.isPersonalProjectKey((String)projectKey)) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            throw new NoSuchProjectException(this.i18nService.getKeyedText("stash.service.project.notfound", "No project with key ''{0}'' exists.", new Object[]{projectKey}));
        }
        return this.repositoryDao.findByProjectKey(projectKey, pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Deprecated
    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository findBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        return this.getBySlug(projectKey, slug);
    }

    @PreAuthorize(value="isAuthenticated() and isRepositoryAccessible(#repository)")
    public InternalRepository findPersonalFork(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        PersonalProject personalProject = this.projectService.getPersonalProject(false);
        if (personalProject == null) {
            return null;
        }
        return this.repositoryDao.findByOriginInProject(InternalConverter.convertToInternalRepository((Repository)repository), personalProject.getId().intValue());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<? extends Repository> findRelated(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return this.repositoryDao.findByHierarchy(InternalConverter.convertToInternalRepository((Repository)repository), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#parent, 'REPO_READ')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository fork(@Nonnull Repository parent, String name) {
        return this.fork(new RepositoryForkRequest.Builder(parent).name(name).build());
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN') and hasRepositoryPermission(#request.parent, 'REPO_READ')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository fork(@Nonnull RepositoryForkRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Repository parent = request.getParent();
        if (!this.isForkingEnabled()) {
            throw new ForkingDisabledException(this.i18nService.getKeyedText("stash.service.repository.forkingdisabled", "Support for forks has been disabled.", new Object[0]), parent);
        }
        if (!parent.isForkable()) {
            throw new ForkingDisabledException(this.i18nService.getKeyedText("stash.service.repository.notforkable", "Forks have been disabled for {0}/{1}.", new Object[]{parent.getProject().getKey(), parent.getSlug()}), parent);
        }
        Project project = request.getProject();
        if (project == null) {
            project = this.projectService.getPersonalProject();
        }
        InternalRepository repository = this.createRepositoryInDatabase((AbstractRepositoryRequest)request, project, parent.getScmId(), parent, true);
        this.createRepositoryInScm(repository);
        return repository;
    }

    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository getById(int id) {
        return (InternalRepository)this.repositoryDao.getById((Object)id);
    }

    @PostAuthorize(value="isRepositoryAccessible(returnObject)")
    public InternalRepository getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        Preconditions.checkNotNull((Object)slug, (Object)"slug");
        return this.repositoryDao.getBySlug(projectKey, slug);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public long getSize(@Nonnull Repository repository) {
        File directory = this.propertiesService.getRepositoryDir((Repository)Preconditions.checkNotNull((Object)repository));
        return directory.isDirectory() ? FileUtils.sizeOfDirectory((File)directory) : 0L;
    }

    @Unsecured(value="Allow anonymous users to check whether forking is enabled")
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean isForkingEnabled() {
        return this.featureManager.isEnabled(Feature.FORKS);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#repository.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository retryCreate(@Nonnull Repository repository) {
        Project project = ((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getProject();
        String projectName = ((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getName();
        String name = repository.getName();
        InternalRepository existing = this.repositoryDao.getBySlug(project.getKey(), repository.getSlug());
        if (existing == null) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.nosuchreponame", "There is no repository with name {0} in project {1}", new Object[]{name, projectName});
            throw new NoSuchEntityException(message);
        }
        if (existing.getState() == Repository.State.INITIALISATION_FAILED) {
            this.repositoryDao.delete((Object)existing);
            InternalRepository newRepository = this.createRepositoryInDatabase((AbstractRepositoryRequest)new RepositoryCreateRequest.Builder((Repository)existing).build(), project, existing.getScmId(), (Repository)existing.getOrigin(), false);
            this.createRepositoryInScm(newRepository);
            existing = newRepository;
        }
        return existing;
    }

    @Unsecured(value="Permission checks are applied while searching for repositories matching the provided criteria")
    public Page<Repository> search(@Nonnull RepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (request.isEmpty()) {
            return PageUtils.asPageOf(Repository.class, this.findAll(pageRequest));
        }
        RepositorySearchCriteria criteria = this.createSearchCriteria(request);
        if (criteria == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Predicate permissionPredicate = request.hasPermission() ? this.predicateFactory.createRepositoryPermissionPredicate(request.getPermission()) : (request.getVisibility() == RepositoryVisibility.PUBLIC ? Predicates.alwaysTrue() : this.predicateFactory.createRepositoryAccessiblePredicate());
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.search(criteria, pageRequest, permissionPredicate));
    }

    @Value(value="${page.max.repositories}")
    public void setMaxRepositoriesPerPage(int maxRepositoriesPerPage) {
        this.maxRepositoriesPerPage = Math.max(maxRepositoriesPerPage, 50);
    }

    @Deprecated
    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#id, 'REPO_ADMIN')")
    @Transactional
    public InternalRepository update(int id, @Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        InternalRepository repository = (InternalRepository)this.repositoryDao.getById((Object)id);
        if (repository == null) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.nosuchrepo", "There is no repository with id {0}", new Object[]{id});
            throw new NoSuchEntityException(message);
        }
        return this.update(((RepositoryUpdateRequest.Builder)new RepositoryUpdateRequest.Builder((Repository)repository).name(name)).build());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.id, 'REPO_ADMIN') and (#request.project == null or hasProjectPermission(#request.project, 'PROJECT_ADMIN'))")
    @Transactional
    public InternalRepository update(@Nonnull RepositoryUpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalRepository repository = (InternalRepository)this.repositoryDao.getById((Object)request.getId());
        if (repository == null) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.nosuchrepo", "There is no repository with id {0}", new Object[]{request.getId()});
            throw new NoSuchEntityException(message);
        }
        InternalRepository current = repository.copy().build();
        InternalRepository updated = current.copy().forkable(request.isForkable()).publiclyAccessible(request.isPublic()).name(request.getName()).project((InternalProject)Objects.firstNonNull((Object)InternalConverter.convertToInternalProject((Project)request.getProject()), (Object)repository.getProject())).build();
        ValidationUtils.validate(this.validator, updated, Update.class);
        this.fireRepositoryModificationRequested((Repository)current, (Repository)updated);
        updated = (InternalRepository)this.repositoryDao.update((Object)updated);
        this.eventPublisher.publish((Object)new RepositoryModifiedEvent((Object)this, (Repository)current, (Repository)updated));
        return updated;
    }

    @Nonnull
    private InternalRepository createRepositoryInDatabase(AbstractRepositoryRequest request, Project project, String scmId, Repository parent, boolean cancelable) {
        String hierarchyId = parent == null ? this.generateToken() : parent.getHierarchyId();
        InternalRepository repository = new InternalRepository.Builder().forkable(request.isForkable()).hierarchyId(hierarchyId).name(request.getName()).origin(InternalConverter.convertToInternalRepository((Repository)parent)).project(InternalConverter.convertToInternalProject((Project)project)).publiclyAccessible(request.isPublic()).scmId(scmId).build();
        ValidationUtils.validate(this.validator, repository, Create.class);
        if (cancelable) {
            if (repository.isFork()) {
                this.fireRepositoryForkRequested((Repository)repository);
            } else {
                this.fireRepositoryCreationRequested((Repository)repository);
            }
        }
        return (InternalRepository)this.repositoryDao.create((Object)repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepositoryInScm(InternalRepository repository) {
        block5: {
            block4: {
                Repository.State state = Repository.State.INITIALISATION_FAILED;
                try {
                    this.validateCanCreateRepositoryOnDisk((Repository)repository);
                    Command command = repository.isFork() ? this.scmService.getCommandFactory((Repository)repository.getOrigin()).fork((Repository)repository) : this.scmService.getCommandFactory((Repository)repository).create();
                    command.call();
                    state = Repository.State.AVAILABLE;
                    repository = this.setRepositoryState(repository, state);
                    if (state != Repository.State.AVAILABLE) break block4;
                }
                catch (Throwable throwable) {
                    repository = this.setRepositoryState(repository, state);
                    if (state == Repository.State.AVAILABLE) {
                        this.eventPublisher.publish(repository.isFork() ? new RepositoryForkedEvent((Object)this, (Repository)repository) : new RepositoryCreatedEvent((Object)this, (Repository)repository));
                    } else {
                        this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
                    }
                    throw throwable;
                }
                this.eventPublisher.publish(repository.isFork() ? new RepositoryForkedEvent((Object)this, (Repository)repository) : new RepositoryCreatedEvent((Object)this, (Repository)repository));
                break block5;
            }
            this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
        }
    }

    private RepositorySearchCriteria createSearchCriteria(RepositorySearchRequest request) {
        RepositorySearchCriteria criteria = new RepositorySearchCriteria().setName(request.getName()).setProjectName(request.getProjectName());
        if (request.hasVisibility()) {
            criteria.setVisibility(request.getVisibility());
            criteria.setOrder(RepositoryOrder.PROJECT_NAME);
            if (!this.featureManager.isEnabled(Feature.PUBLIC_ACCESS)) {
                if (request.getVisibility() == RepositoryVisibility.PUBLIC) {
                    return null;
                }
                if (request.getVisibility() == RepositoryVisibility.PRIVATE) {
                    criteria.setVisibility(null);
                }
            }
        } else {
            criteria.setOrder(RepositoryOrder.REPO_NAME);
        }
        return criteria;
    }

    private Iterable<Integer> deleteInDatabase(InternalRepository repository) {
        Iterable forkIds = this.repositoryDao.getForkIds(repository);
        if (!Iterables.isEmpty((Iterable)forkIds)) {
            this.repositoryDao.updateOrigin(repository, repository.getOrigin());
        }
        this.repositoryDao.deleteById((Object)repository.getId());
        this.fireRepositoryDeleted(repository);
        return forkIds;
    }

    private void fireRepositoryCreationRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryCreationRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.creationcanceled", "Repository creation was canceled.", new Object[0]);
            throw new RepositoryCreationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryDeleted(InternalRepository repository) {
        this.eventPublisher.publish((Object)new RepositoryDeletedEvent((Object)this, (Repository)repository));
    }

    private void fireRepositoryDeletionRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryDeletionRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.deletioncanceled", "Repository deletion was canceled.", new Object[0]);
            throw new RepositoryDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryForkRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryForkRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.forkcanceled", "Forked repository creation was canceled.", new Object[0]);
            throw new RepositoryForkCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryModificationRequested(Repository current, Repository updated) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryModificationRequestedEvent((Object)this, current, updated, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.repository.updatecanceled", "Repository modification was canceled.", new Object[0]);
            throw new RepositoryModificationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    @Nonnull
    private String generateToken() {
        String token = this.tokenGenerator.generateToken();
        if (token.length() > 20) {
            token = token.substring(0, 20);
        }
        return token;
    }

    private InternalRepository setRepositoryState(InternalRepository repository, Repository.State state) {
        return (InternalRepository)this.repositoryDao.update((Object)repository.copy().state(state).build());
    }

    private void validateCanCreateRepositoryOnDisk(Repository repository) {
        File repositoryRoot = this.propertiesService.getRepositoryDir(repository);
        if (repositoryRoot.isFile()) {
            throw new IllegalRepositoryStateException(this.i18nService.getKeyedText("stash.service.repository.createfailed.filepresent", "Cannot create repository {0} at {1}; a file exists at the same location", new Object[]{repository.getName(), repositoryRoot}));
        }
        if (repositoryRoot.isDirectory()) {
            throw new IllegalRepositoryStateException(this.i18nService.getKeyedText("stash.service.repository.createfailed.directorypresent", "Cannot create repository {0} at {1}; a directory exists at the same location", new Object[]{repository.getName(), repositoryRoot}));
        }
    }
}

