/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.exception.FormValidationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.plugin.ValidatorModuleDescriptor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositorySettings;
import com.atlassian.stash.internal.repository.InternalRepositorySettingsService;
import com.atlassian.stash.internal.repository.RepositorySettingsDao;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.setting.RepositorySettingsValidator;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.setting.SettingsValidationErrors;
import com.atlassian.stash.validation.FormErrors;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

@Service(value="repositorySettingService")
public class DefaultRepositorySettingService
extends AbstractService
implements InternalRepositorySettingsService {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final RepositorySettingsDao repositorySettingsDao;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private static final Function<InternalRepositorySettings, Settings> TO_SETTINGS = new Function<InternalRepositorySettings, Settings>(){

        public Settings apply(InternalRepositorySettings settings) {
            if (settings == null) {
                return null;
            }
            try {
                return new MapSettingsBuilder().addAll((Map)MAPPER.readValue(settings.getData(), Map.class)).build();
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Jackson failed to deserialize settings for module %s from the database.", settings.getKey()), e);
            }
        }
    };

    @Autowired
    public DefaultRepositorySettingService(RepositorySettingsDao repositorySettingsDao, I18nService i18nService, PluginAccessor pluginAccessor) {
        this.repositorySettingsDao = repositorySettingsDao;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    @Nullable
    public Settings findByKey(@Nonnull Repository repo, @Nonnull String key) {
        Preconditions.checkNotNull((Object)repo, (Object)"repository");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        return (Settings)TO_SETTINGS.apply((Object)this.repositorySettingsDao.findByKey(InternalConverter.convertToInternalRepository((Repository)repo), key));
    }

    @Nonnull
    public Collection<String> findKeysWithSettings(@Nonnull Repository repository, @Nonnull Collection<String> keys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(keys, (Object)"keys");
        if (keys.isEmpty()) {
            return keys;
        }
        return this.repositorySettingsDao.findKeysWithSettings(InternalConverter.convertToInternalRepository((Repository)repository), keys);
    }

    @Nonnull
    public Map<String, Settings> findByRepository(@Nonnull Repository repo, @Nonnull Collection<String> keys) {
        Preconditions.checkNotNull((Object)repo, (Object)"repository");
        Preconditions.checkNotNull(keys, (Object)"keys");
        return Maps.transformValues((Map)Maps.uniqueIndex((Iterable)this.repositorySettingsDao.findByRepository(InternalConverter.convertToInternalRepository((Repository)repo), keys), (Function)InternalRepositorySettings.TO_KEY), TO_SETTINGS);
    }

    @Transactional
    public Settings save(@Nonnull Repository repository, @Nonnull String moduleKey, @Nonnull Settings settings) throws FormValidationException {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)moduleKey, (Object)"moduleKey");
        Preconditions.checkNotNull((Object)settings, (Object)"settings");
        ModuleDescriptor enabledPluginModule = this.pluginAccessor.getEnabledPluginModule(moduleKey);
        Preconditions.checkArgument((boolean)(enabledPluginModule instanceof ValidatorModuleDescriptor), (Object)("Module '" + moduleKey + "' does not implement ValidatorModuleDescriptor"));
        ValidatorModuleDescriptor moduleDescriptor = (ValidatorModuleDescriptor)enabledPluginModule;
        this.validate(moduleDescriptor.getValidator(), repository, settings);
        this.save(InternalConverter.convertToInternalRepository((Repository)repository), moduleKey, this.serialize(settings));
        return settings;
    }

    private void validate(RepositorySettingsValidator validator, Repository repository, Settings settings) throws FormValidationException {
        if (validator != null) {
            SettingsErrors errors = new SettingsErrors(settings);
            validator.validate(settings, (SettingsValidationErrors)new SettingsValidationErrorsImpl((Errors)errors), repository);
            if (errors.hasErrors()) {
                throw new FormValidationException(this.i18nService.getKeyedText("stash.repository.setting.validation.error", "Validation errors occurred when saving settings", new Object[0]), (FormErrors)new ErrorsWrapper((Errors)errors));
            }
        }
    }

    private String serialize(Settings settings) {
        try {
            return MAPPER.writeValueAsString((Object)settings.asMap());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private InternalRepositorySettings save(InternalRepository repository, String key, String data) {
        if (data.length() > 32768) {
            throw new ArgumentValidationException(this.i18nService.getKeyedText("stash.repository.setting.length.error", "The supplied settings are over the current maximum size {0}", new Object[]{32768}));
        }
        InternalRepositorySettings settings = this.repositorySettingsDao.findByKey(repository, key);
        if (settings == null) {
            return (InternalRepositorySettings)this.repositorySettingsDao.create((Object)new InternalRepositorySettings.Builder().repo(repository).key(key).data(data).build());
        }
        return (InternalRepositorySettings)this.repositorySettingsDao.update((Object)new InternalRepositorySettings.Builder(settings).data(data).build());
    }

    @Transactional
    public void delete(@Nonnull Repository repository, @Nonnull String key) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        this.repositorySettingsDao.deleteByKey(InternalConverter.convertToInternalRepository((Repository)repository), key);
    }

    private static class ErrorsWrapper
    implements FormErrors {
        private final Errors errors;

        private ErrorsWrapper(Errors errors) {
            this.errors = errors;
        }

        @Nonnull
        public Collection<String> getErrors(@Nonnull String field) {
            return Collections2.transform((Collection)this.errors.getFieldErrors(field), (Function)new Function<FieldError, String>(){

                public String apply(FieldError input) {
                    return input.getDefaultMessage();
                }
            });
        }

        @Nonnull
        public Map<String, Collection<String>> getFieldErrors() {
            HashMultimap errorMap = HashMultimap.create();
            for (FieldError message : this.errors.getFieldErrors()) {
                errorMap.put((Object)message.getField(), (Object)message.getDefaultMessage());
            }
            return errorMap.asMap();
        }

        @Nonnull
        public Collection<String> getFormErrors() {
            return Collections2.transform((Collection)this.errors.getGlobalErrors(), (Function)new Function<ObjectError, String>(){

                public String apply(ObjectError input) {
                    return input.getDefaultMessage();
                }
            });
        }

        public boolean isEmpty() {
            return !this.errors.hasErrors();
        }
    }

    private static class SettingsErrors
    extends AbstractBindingResult {
        private final Settings settings;

        public SettingsErrors(Settings settings) {
            super("__OBJECT__");
            this.settings = settings;
        }

        public Object getTarget() {
            return this.settings;
        }

        protected Object getActualFieldValue(String field) {
            return this.settings.asMap().get(field);
        }
    }

    private static class SettingsValidationErrorsImpl
    implements SettingsValidationErrors {
        private final Errors errors;

        public SettingsValidationErrorsImpl(Errors errors) {
            this.errors = errors;
        }

        public void addFieldError(String fieldName, String errorMessage) {
            this.errors.rejectValue(fieldName, errorMessage, errorMessage);
        }

        public void addFormError(String errorMessage) {
            this.errors.reject(errorMessage, errorMessage);
        }
    }
}

