/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.stash.content.AbstractChangesetCallback;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.InternalRescopeDetails;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestRescopeActivity;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RescopePullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private static final Predicate<InternalPullRequestRescopeActivity> IS_PRECALCULATED = new Predicate<InternalPullRequestRescopeActivity>(){

        public boolean apply(InternalPullRequestRescopeActivity activity) {
            return activity.isPrecalculated();
        }
    };
    private static final Function<InternalPullRequestRescopeCommit, String> TO_CHANGESET_ID = new Function<InternalPullRequestRescopeCommit, String>(){

        public String apply(InternalPullRequestRescopeCommit commit) {
            return commit.getChangesetId();
        }
    };
    private final RescopeProcessor rescopeProcessor;
    private final ScmService scmService;

    @Autowired
    public RescopePullRequestActivityEnricher(RescopeProcessor rescopeProcessor, ScmService scmService) {
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Page<InternalPullRequestActivity> activities) {
        String timerName = "Enrich: Rescopes from " + pullRequest.getGlobalId() + " (" + activities.getSize() + ")";
        Timer timer = TimerUtils.start((String)timerName);
        try {
            WinnowingVisitor visitor = new WinnowingVisitor();
            for (InternalPullRequestActivity activity : activities.getValues()) {
                activity.accept((PullRequestActivityVisitor)visitor);
            }
            List<InternalPullRequestRescopeActivity> rescopes = visitor.getActivities();
            if (!rescopes.isEmpty()) {
                this.rescopeProcessor.processAll(pullRequest, rescopes);
                this.loadChangesets(pullRequest, rescopes);
            }
        }
        finally {
            timer.stop();
        }
    }

    private void loadChangesets(InternalPullRequest pullRequest, List<InternalPullRequestRescopeActivity> all) {
        Collection activities = Collections2.filter(all, IS_PRECALCULATED);
        HashSet changesetIds = Sets.newHashSet();
        for (InternalPullRequestRescopeActivity activity : activities) {
            Iterables.addAll((Collection)changesetIds, (Iterable)Collections2.transform((Collection)activity.getCommits(), TO_CHANGESET_ID));
        }
        if (changesetIds.isEmpty()) {
            return;
        }
        final HashMap changesetsById = Maps.newHashMapWithExpectedSize((int)changesetIds.size());
        this.scmService.getCommandFactory((Repository)pullRequest.getScopeRepository()).commits(new CommitsCommandParameters.Builder().include((Iterable)changesetIds).secondaryRepository((Repository)pullRequest.getFromRef().getRepository()).traverse(false).build(), (ChangesetCallback)new AbstractChangesetCallback(){

            public boolean onChangeset(Changeset changeset) {
                changesetsById.put(changeset.getId(), changeset);
                return true;
            }
        }).call();
        for (InternalPullRequestRescopeActivity activity : activities) {
            InternalRescopeDetails.Builder added = new InternalRescopeDetails.Builder().total(activity.getTotalAdded());
            InternalRescopeDetails.Builder removed = new InternalRescopeDetails.Builder().total(activity.getTotalRemoved());
            for (InternalPullRequestRescopeCommit commit : activity.getCommits()) {
                Changeset changeset = (Changeset)changesetsById.get(commit.getChangesetId());
                if (changeset == null) continue;
                if (commit.getAction() == PullRequestRescopeCommitAction.ADDED) {
                    added.changeset(changeset);
                    continue;
                }
                removed.changeset(changeset);
            }
            activity.setAdded(added.build());
            activity.setRemoved(removed.build());
        }
    }

    private static class WinnowingVisitor
    extends AbstractPullRequestActivityVisitor {
        private final ImmutableList.Builder<InternalPullRequestRescopeActivity> builder = ImmutableList.builder();

        private WinnowingVisitor() {
        }

        public List<InternalPullRequestRescopeActivity> getActivities() {
            return this.builder.build();
        }

        public void visit(@Nonnull PullRequestRescopeActivity activity) {
            this.builder.add((Object)((InternalPullRequestRescopeActivity)activity));
        }
    }
}

