/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestRef;
import com.atlassian.stash.pull.PullRequestSearchRequest;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.pull.MinimalPullRequest;
import com.atlassian.stash.scm.pull.RepositoryRescopeCommandParameters;
import com.atlassian.stash.scm.pull.RepositoryRescopeContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

@Component(value="pullRequestRescopeListener")
public class PullRequestRescopeListener
implements ApplicationListener<ContextRefreshedEvent> {
    public static final int MAX_RESCOPE_ATTEMPTS = 5;
    private static final Function<PullRequest, MinimalPullRequest> MINIMIZER = new Function<PullRequest, MinimalPullRequest>(){

        public SimpleMinimalPullRequest apply(PullRequest pullRequest) {
            return new SimpleMinimalPullRequest(pullRequest);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeListener.class);
    private final RescopeUpdateStrategy decline = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            PullRequestRescopeListener.this.pullRequestService.decline(pullRequest.globalId, pullRequest.version);
        }

        @Override
        public String getErrorFormat() {
            return "Could not decline pull request %1$s";
        }
    };
    private final RescopeUpdateStrategy merge = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            PullRequestRescopeListener.this.pullRequestService.closeMerged(pullRequest.globalId, pullRequest.version);
        }

        @Override
        public String getErrorFormat() {
            return "Could not mark pull request %1$s as merged";
        }
    };
    private final RescopeUpdateStrategy rescope = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            PullRequestRescopeListener.this.pullRequestService.updateScope(pullRequest.globalId, pullRequest.version, pullRequest.newFromHash, pullRequest.newToHash);
        }

        @Override
        public String getErrorFormat() {
            return "Could not rescope pull request %1$s";
        }
    };
    private final InternalLockService lockService;
    private final InternalPullRequestService pullRequestService;
    private final RescopeRequestDao rescopeRequestDao;
    private final InternalScmService scmService;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    private volatile boolean initialized;

    @Autowired
    public PullRequestRescopeListener(RescopeRequestDao rescopeRequestDao, InternalPullRequestService pullRequestService, InternalLockService lockService, InternalScmService scmService, SecurityService securityService, PlatformTransactionManager transactionManager) {
        this.lockService = lockService;
        this.rescopeRequestDao = rescopeRequestDao;
        this.pullRequestService = pullRequestService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public synchronized void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        List pendingRescopes = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<InternalRescopeRequest>>(){

            public List<InternalRescopeRequest> doInTransaction(TransactionStatus status) {
                return PullRequestRescopeListener.this.rescopeRequestDao.findAll();
            }
        });
        HashSet rescopedRepositories = Sets.newHashSet();
        for (final InternalRescopeRequest rescopeRequest : pendingRescopes) {
            Integer repositoryId = rescopeRequest.getRepository().getId();
            if (rescopedRepositories.contains(repositoryId)) {
                this.deleteRescopeRequest(rescopeRequest);
                continue;
            }
            if (rescopeRequest.getBranchId() == null) {
                rescopedRepositories.add(repositoryId);
            }
            this.securityService.doAsUser("resuming pull request rescopes after restart", rescopeRequest.getUser().getUsername(), (Operation)new UncheckedOperation<Void>(){

                public Void perform() {
                    log.debug("Resuming pull request rescopes for repository {} after restart", (Object)rescopeRequest.getRepository().getSlug());
                    PullRequestRescopeListener.this.updatePullRequestsFor(rescopeRequest);
                    return null;
                }
            });
        }
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        Collection changes = event.getRefChanges();
        if (CollectionUtils.isNotEmpty((Collection)changes)) {
            Repository repository = event.getRepository();
            StashUser user = event.getUser();
            if (user == null) {
                log.debug("Skipping rescopes for repository {}/{} because the triggering user could not be determined", (Object)repository.getProject().getKey(), (Object)repository.getSlug());
            } else {
                String branch = changes.size() == 1 ? ((RefChange)Iterables.getOnlyElement((Iterable)changes)).getRefId() : null;
                this.updatePullRequestsFor(this.createRescopeRequestFor(user, repository, branch));
            }
        }
    }

    private boolean attemptUpdatePullRequestsFor(Repository repository, String branchId, int attempt) {
        ImmutableSet pullRequests = ImmutableSet.copyOf((Iterable)Iterables.transform(this.findAffectedPullRequests(repository, branchId), MINIMIZER));
        if (pullRequests.isEmpty()) {
            return true;
        }
        SimpleRepositoryRescopeContext context = new SimpleRepositoryRescopeContext((Set<MinimalPullRequest>)pullRequests);
        this.scmService.rescope(new RepositoryRescopeCommandParameters.Builder().repository(repository).rescopeContext((RepositoryRescopeContext)context).build());
        int failures = PullRequestRescopeListener.applyUpdate(context.declined, this.decline, attempt) + PullRequestRescopeListener.applyUpdate(context.merged, this.merge, attempt) + PullRequestRescopeListener.applyUpdate(context.updated, this.rescope, attempt);
        return failures == 0;
    }

    private InternalRescopeRequest createRescopeRequestFor(StashUser user, Repository repository, String branchId) {
        final InternalRescopeRequest request = new InternalRescopeRequest(null, InternalConverter.convertToInternalRepository((Repository)repository), branchId, InternalConverter.convertToInternalUser((StashUser)user));
        return (InternalRescopeRequest)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalRescopeRequest>(){

            public InternalRescopeRequest doInTransaction(TransactionStatus status) {
                return PullRequestRescopeListener.this.rescopeRequestDao.create(request);
            }
        });
    }

    private void deleteRescopeRequest(final InternalRescopeRequest rescopeRequest) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                PullRequestRescopeListener.this.rescopeRequestDao.delete(rescopeRequest);
                return null;
            }
        });
    }

    private Iterable<PullRequest> findAffectedPullRequests(final Repository repository, final String branchId) {
        PageRequest initialPageRequest = PageUtils.newRequest((int)0, (int)100);
        return Iterables.concat((Iterable)new PagedIterable((PageProvider)new PageProvider<PullRequest>(){

            public Page<PullRequest> get(PageRequest pageRequest) {
                return PullRequestRescopeListener.this.pullRequestService.search(new PullRequestSearchRequest.Builder().toBranchId(branchId).toRepositoryId(repository.getId()).state(PullRequestState.OPEN).build(), pageRequest);
            }
        }, initialPageRequest), (Iterable)new PagedIterable((PageProvider)new PageProvider<PullRequest>(){

            public Page<PullRequest> get(PageRequest pageRequest) {
                return PullRequestRescopeListener.this.pullRequestService.search(new PullRequestSearchRequest.Builder().fromBranchId(branchId).fromRepositoryId(repository.getId()).state(PullRequestState.OPEN).build(), pageRequest);
            }
        }, initialPageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePullRequestsFor(final InternalRescopeRequest rescopeRequest) {
        InternalRepository repository = rescopeRequest.getRepository();
        Timer timer = TimerUtils.start((String)("Rescoping pull requests for " + repository.getId()));
        try {
            this.lockService.doWithLock(repository, (Operation)new UncheckedOperation<Void>(){

                public Void perform() {
                    return (Void)PullRequestRescopeListener.this.securityService.doWithPermission("Rescoping pull requests", Permission.REPO_READ, (Operation)new Operation<Void, ServiceException>(){

                        public Void perform() throws ServiceException {
                            boolean allPullRequestsUpdated;
                            int attempt = 1;
                            while (!(allPullRequestsUpdated = PullRequestRescopeListener.this.attemptUpdatePullRequestsFor((Repository)rescopeRequest.getRepository(), rescopeRequest.getBranchId(), attempt)) && attempt++ < 5) {
                            }
                            PullRequestRescopeListener.this.deleteRescopeRequest(rescopeRequest);
                            return null;
                        }
                    });
                }
            });
        }
        finally {
            timer.stop();
        }
    }

    private static int applyUpdate(Set<SimpleMinimalPullRequest> pullRequests, RescopeUpdateStrategy strategy, int attempt) {
        int failures = 0;
        for (SimpleMinimalPullRequest pullRequest : pullRequests) {
            try {
                strategy.apply(pullRequest);
            }
            catch (RuntimeException e) {
                ++failures;
                PullRequestRescopeListener.logFailure(String.format(strategy.getErrorFormat(), pullRequest), e, attempt);
            }
        }
        return failures;
    }

    private static void logFailure(String message, Throwable throwable, int attempt) {
        if (attempt < 5) {
            log.debug(message, throwable);
        } else {
            log.warn(message, throwable);
        }
    }

    private static interface RescopeUpdateStrategy {
        public void apply(SimpleMinimalPullRequest var1);

        public String getErrorFormat();
    }

    private static class SimpleMinimalPullRequest
    implements MinimalPullRequest {
        private final PullRequestRef fromRef;
        private final long globalId;
        private final long id;
        private final PullRequestRef toRef;
        private final int version;
        private String newFromHash;
        private String newToHash;

        private SimpleMinimalPullRequest(PullRequest pullRequest) {
            this.fromRef = pullRequest.getFromRef();
            this.globalId = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId();
            this.id = pullRequest.getId();
            this.toRef = pullRequest.getToRef();
            this.version = pullRequest.getVersion();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SimpleMinimalPullRequest) {
                return this.globalId == ((SimpleMinimalPullRequest)o).globalId;
            }
            return false;
        }

        @Nonnull
        public PullRequestRef getFromRef() {
            return this.fromRef;
        }

        public long getId() {
            return this.id;
        }

        @Nonnull
        public PullRequestRef getToRef() {
            return this.toRef;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            return ObjectUtils.hashCode((long)this.globalId);
        }

        public String toString() {
            return this.getToRef().getRepository().getProject().getKey() + "/" + this.getToRef().getRepository().getSlug() + "#" + this.id;
        }
    }

    private static class SimpleRepositoryRescopeContext
    implements RepositoryRescopeContext {
        private final Set<SimpleMinimalPullRequest> declined;
        private final Set<SimpleMinimalPullRequest> merged;
        private final Set<MinimalPullRequest> pullRequests;
        private final Set<SimpleMinimalPullRequest> updated;

        public SimpleRepositoryRescopeContext(Set<MinimalPullRequest> pullRequests) {
            this.pullRequests = pullRequests;
            this.declined = Sets.newHashSet();
            this.merged = Sets.newHashSet();
            this.updated = Sets.newHashSet();
        }

        public void decline(@Nonnull MinimalPullRequest pullRequest) {
            this.declined.add(SimpleRepositoryRescopeContext.checkPullRequest(pullRequest));
        }

        public Iterator<MinimalPullRequest> iterator() {
            return this.pullRequests.iterator();
        }

        public void merge(@Nonnull MinimalPullRequest pullRequest) {
            this.merged.add(SimpleRepositoryRescopeContext.checkPullRequest(pullRequest));
        }

        public void update(@Nonnull MinimalPullRequest pullRequest, @Nonnull String newFromHash, @Nonnull String newToHash) {
            SimpleMinimalPullRequest minimal = SimpleRepositoryRescopeContext.checkPullRequest(pullRequest);
            minimal.newFromHash = newFromHash;
            minimal.newToHash = newToHash;
            this.updated.add(minimal);
        }

        private static SimpleMinimalPullRequest checkPullRequest(MinimalPullRequest pullRequest) {
            Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            Preconditions.checkArgument((boolean)(pullRequest instanceof SimpleMinimalPullRequest), (Object)"The provided MinimalPullRequest does not belong to this RepositoryRescopeContext");
            return (SimpleMinimalPullRequest)pullRequest;
        }
    }
}

