/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentService;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftRequestDao;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.CompositeCommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.InternalDriftRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DriftCommentUpdateProcessor
implements CommentUpdateProcessor {
    private static final int MAX_ATTEMPTS = 20;
    private static final Logger log = LoggerFactory.getLogger(DriftCommentUpdateProcessor.class);
    private final CommentDriftRequestDao driftRequestDao;
    private final ExecutorService executorService;
    private final InternalLockService lockService;
    private final Map<Long, List<InternalDriftRequest>> pending;
    private final Map<Long, Integer> failedAttemptCountForPullRequest;
    private final ScmService scmService;
    private final CommentDriftStrategy strategy;
    private final TransactionTemplate transactionTemplate;
    @Autowired
    private InternalPullRequestCommentService commentService;

    public DriftCommentUpdateProcessor(ExecutorService executorService, InternalLockService lockService, ScmService scmService, CommentDriftRequestDao driftRequestDao, PlatformTransactionManager transactionManager, List<CommentDriftStrategy> strategies) {
        this.driftRequestDao = driftRequestDao;
        this.executorService = executorService;
        this.lockService = lockService;
        this.scmService = scmService;
        this.failedAttemptCountForPullRequest = Maps.newHashMap();
        this.pending = Maps.newHashMap();
        this.strategy = new CompositeCommentDriftStrategy(strategies);
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                List requests = DriftCommentUpdateProcessor.this.driftRequestDao.findAll();
                for (InternalDriftRequest driftRequest : requests) {
                    DriftCommentUpdateProcessor.this.schedule(driftRequest);
                }
            }
        });
    }

    @Override
    public void maybeProcess(InternalPullRequest pullRequest) {
        new CommentDriftBoostrapper(pullRequest).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(InternalPullRequest pullRequest, String previousFromHash, String previousToHash) {
        List<InternalDriftRequest> driftRequests;
        List<InternalDriftRequest> list = driftRequests = this.getPendingDrifts(pullRequest);
        synchronized (list) {
            final InternalDriftRequest request = new InternalDriftRequest(null, pullRequest, previousFromHash, previousToHash, pullRequest.getFromRef().getLatestChangeset(), pullRequest.getToRef().getLatestChangeset());
            this.schedule(request);
            try {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalDriftRequest>(){

                    public InternalDriftRequest doInTransaction(TransactionStatus status) {
                        return DriftCommentUpdateProcessor.this.driftRequestDao.create(request);
                    }
                });
            }
            catch (Exception e) {
                log.info("Problem persisting drift request ({}). Scheduled the request anyway.", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InternalDriftRequest> getPendingDrifts(InternalPullRequest pullRequest) {
        Map<Long, List<InternalDriftRequest>> map = this.pending;
        synchronized (map) {
            Long globalId = pullRequest.getGlobalId();
            LinkedList drifts = this.pending.get(globalId);
            if (drifts == null) {
                drifts = Lists.newLinkedList();
                this.pending.put(globalId, drifts);
            }
            return drifts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(InternalDriftRequest request) {
        List<InternalDriftRequest> driftRequests;
        List<InternalDriftRequest> list = driftRequests = this.getPendingDrifts(request.getPullRequest());
        synchronized (list) {
            log.debug("scheduling drift for pull request {} (oldFrom: {}, oldTo: {}, newFrom: {}, newTo: {})", new Object[]{request.getPullRequest().getGlobalId(), request.getOldFromHash(), request.getOldToHash(), request.getNewFromHash(), request.getNewToHash()});
            driftRequests.add(request);
            this.executorService.submit(new CommentDriftBoostrapper(request.getPullRequest()));
        }
    }

    private class CommentDriftOperation
    implements UncheckedOperation<Void> {
        private final InternalPullRequest pullRequest;

        private CommentDriftOperation(InternalPullRequest pullRequest) {
            this.pullRequest = pullRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void perform() {
            List pendingDrifts = DriftCommentUpdateProcessor.this.getPendingDrifts(this.pullRequest);
            final ArrayList drifts = Lists.newArrayListWithCapacity((int)pendingDrifts.size());
            List list = pendingDrifts;
            synchronized (list) {
                drifts.addAll(pendingDrifts);
                pendingDrifts.clear();
            }
            if (drifts.isEmpty()) {
                log.debug("{}: No rescopes are pending drift", (Object)this.pullRequest.getGlobalId());
                return null;
            }
            final CommentDriftCalculator calculator = this.calculatorFor(drifts);
            try {
                DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void doInTransaction(TransactionStatus status) {
                        Timer timer = TimerUtils.start((String)("Drift: Calculate for " + calculator));
                        try {
                            calculator.calculate();
                            DriftCommentUpdateProcessor.this.driftRequestDao.deleteAll(drifts);
                        }
                        finally {
                            timer.stop();
                        }
                        return null;
                    }
                });
                DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.remove(this.pullRequest.getGlobalId());
            }
            catch (Exception e) {
                Integer failedAttempts = (Integer)DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.get(this.pullRequest.getGlobalId());
                failedAttempts = failedAttempts != null ? failedAttempts + 1 : 1;
                if (failedAttempts <= 20 && this.isRecoverable(e)) {
                    DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.put(this.pullRequest.getGlobalId(), failedAttempts);
                    log.info("Failed to drift comments for {} (attempt {} of {}; error was {}). Rescheduling", new Object[]{this.pullRequest.getGlobalId(), failedAttempts, 20, e.getMessage()});
                    List list2 = pendingDrifts = DriftCommentUpdateProcessor.this.getPendingDrifts(this.pullRequest);
                    synchronized (list2) {
                        pendingDrifts.addAll(0, drifts);
                        DriftCommentUpdateProcessor.this.executorService.submit(new CommentDriftBoostrapper(this.pullRequest));
                    }
                }
                DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.remove(this.pullRequest.getGlobalId());
                InternalDriftRequest first = (InternalDriftRequest)drifts.get(0);
                InternalDriftRequest last = (InternalDriftRequest)drifts.get(drifts.size() - 1);
                String errorMessage = String.format("Error calculating comment drift for pull request %d (%d attempts):\n\told fromHash = %s\n\t old toHash = %s\n\tnew fromHash = %s\n\tnew toHash = %s", this.pullRequest.getGlobalId(), failedAttempts, first.getOldFromHash(), first.getOldToHash(), last.getNewFromHash(), last.getNewToHash());
                log.error(errorMessage, (Throwable)e);
            }
            return null;
        }

        private CommentDriftCalculator calculatorFor(List<InternalDriftRequest> drifts) {
            InternalDriftRequest first = drifts.get(0);
            InternalDriftRequest last = drifts.get(drifts.size() - 1);
            if (drifts.size() > 1) {
                log.debug("{}: Calculating combined drift for {} rescopes", (Object)this.pullRequest.getGlobalId(), (Object)drifts.size());
            }
            InternalPullRequest pullRequestToDrift = new InternalPullRequest.Builder(this.pullRequest).fromRef(new InternalPullRequestRef.Builder(this.pullRequest.getFromRef()).hash(last.getNewFromHash()).build()).toRef(new InternalPullRequestRef.Builder(this.pullRequest.getToRef()).hash(last.getNewToHash()).build()).build();
            return new CommentDriftCalculator(pullRequestToDrift, first.getOldFromHash(), first.getOldToHash());
        }

        private boolean isRecoverable(Exception e) {
            return DataAccessException.class.isAssignableFrom(e.getClass()) || TransactionException.class.isAssignableFrom(e.getClass()) || HibernateException.class.isAssignableFrom(e.getClass());
        }
    }

    private class CommentDriftBoostrapper
    implements Runnable {
        private final InternalPullRequest pullRequest;

        private CommentDriftBoostrapper(InternalPullRequest pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public void run() {
            DriftCommentUpdateProcessor.this.lockService.doWithLock(this.pullRequest, (Operation)new CommentDriftOperation(this.pullRequest));
        }
    }

    private class CommentDriftCalculator {
        private final String previousFromHash;
        private final String previousToHash;
        private final InternalPullRequest pullRequest;
        private final InternalRepository repository;

        public CommentDriftCalculator(InternalPullRequest pullRequest, String previousFromHash, String previousToHash) {
            this.pullRequest = pullRequest;
            this.previousFromHash = previousFromHash;
            this.previousToHash = previousToHash;
            this.repository = pullRequest.getToRef().getRepository();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculate() {
            List anchors;
            Timer timer = TimerUtils.start((String)("Drift: Find anchors " + this.pullRequest.getGlobalId()));
            try {
                anchors = DriftCommentUpdateProcessor.this.commentService.findDiffAnchors(this.pullRequest);
            }
            finally {
                timer.stop();
            }
            if (anchors.isEmpty()) {
                log.debug("{}:{} has no active diff comments", (Object)this.repository.getId(), (Object)this.pullRequest.getId());
                return;
            }
            PullRequestEffectiveDiff effectiveDiff = (PullRequestEffectiveDiff)DriftCommentUpdateProcessor.this.scmService.getPullRequestCommandFactory((PullRequest)this.pullRequest).effectiveDiff().call();
            DriftContext context = new DriftContext(this.repository, this.pullRequest, this.previousFromHash, this.previousToHash, effectiveDiff, anchors);
            InternalPullRequestDiffCommentAnchor anchor = (InternalPullRequestDiffCommentAnchor)anchors.get(0);
            if (effectiveDiff.getSinceId().equals(anchor.getFromHash()) && effectiveDiff.getUntilId().equals(anchor.getToHash())) {
                log.debug("{}:{} comments have already been drifted. (fromHash: {}, toHash: {})", new Object[]{this.repository.getId(), this.pullRequest.getId(), effectiveDiff.getSinceId(), effectiveDiff.getUntilId()});
                return;
            }
            timer = TimerUtils.start((String)("Drift: Strategy - " + DriftCommentUpdateProcessor.this.strategy.getName() + " " + this.pullRequest.getGlobalId()));
            try {
                DriftCommentUpdateProcessor.this.strategy.apply(context);
            }
            finally {
                timer.stop();
            }
            timer = TimerUtils.start((String)("Drift: Update anchors " + this.pullRequest.getGlobalId()));
            try {
                DriftCommentUpdateProcessor.this.commentService.updateAnchors(context.done());
            }
            finally {
                timer.stop();
            }
        }

        public String toString() {
            return this.pullRequest.getGlobalId() + "@" + this.pullRequest.getVersion();
        }
    }
}

