/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.core.OrderComparator;

public class CompositeCommentDriftStrategy
implements CommentDriftStrategy {
    private final List<CommentDriftStrategy> strategies;

    public CompositeCommentDriftStrategy(List<CommentDriftStrategy> strategies) {
        this.strategies = Lists.newArrayList(strategies);
        OrderComparator.sort(this.strategies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@Nonnull DriftContext context) {
        Long pullRequestId = context.getPullRequest().getGlobalId();
        for (CommentDriftStrategy strategy : this.strategies) {
            Timer timer = TimerUtils.start((String)("Drift: Strategy - " + strategy.getName() + " " + pullRequestId));
            try {
                strategy.apply(context);
            }
            finally {
                timer.stop();
            }
            if (!context.isEmpty()) continue;
            break;
        }
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder("Composite (");
        boolean first = true;
        for (CommentDriftStrategy strategy : this.strategies) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(strategy.getName());
        }
        return builder.append(")").toString();
    }
}

