/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.stash.content.DiffSegment;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.content.InternalDiffHunk;
import com.atlassian.stash.content.InternalDiffSegment;
import com.atlassian.stash.internal.pull.comment.diff.DiffComment;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextWindow;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class DiffContext {
    private final DiffContextWindow afterWindow;
    private final DiffComment comment;
    private final DiffContextLine commentLine;
    private final List<DiffContextLine> linesBefore;

    public DiffContext(@Nonnull DiffComment comment, @Nonnull DiffContextLine line, @Nonnull List<DiffContextLine> linesBefore) {
        this.comment = this.checkNoDiff((DiffComment)Preconditions.checkNotNull((Object)comment, (Object)"comment"));
        this.linesBefore = (List)Preconditions.checkNotNull(linesBefore, (Object)"linesBefore");
        this.afterWindow = new DiffContextWindow();
        this.commentLine = ((DiffContextLine)Preconditions.checkNotNull((Object)line, (Object)"line")).withComment(comment.getId());
    }

    public void done() {
        this.checkNoDiff(this.comment).applyDiff(this.newDiffHunk(this.afterWindow.snapshot()));
    }

    public boolean offer(DiffContextLine line) {
        return this.afterWindow.offer(line);
    }

    private DiffComment checkNoDiff(DiffComment comment) {
        if (comment.isDiffApplied()) {
            throw new IllegalStateException("The DiffComment has already had a diff applied to it");
        }
        return comment;
    }

    private InternalDiffHunk newDiffHunk(@Nonnull List<DiffContextLine> linesAfter) {
        InternalDiffHunk.Builder hunkBuilder = new InternalDiffHunk.Builder();
        InternalDiffSegment.Builder segmentBuilder = null;
        DiffSegmentType type = null;
        int sourceSpan = 0;
        int destSpan = 0;
        for (DiffContextLine contextLine : Iterables.concat(this.linesBefore, Arrays.asList(this.commentLine), linesAfter)) {
            if (segmentBuilder == null || type != contextLine.getType()) {
                if (segmentBuilder == null) {
                    hunkBuilder.destinationLine(contextLine.getDestination()).sourceLine(contextLine.getSource());
                } else {
                    hunkBuilder.segment((DiffSegment)segmentBuilder.build());
                }
                segmentBuilder = contextLine.startNewSegment();
                type = contextLine.getType();
            } else {
                contextLine.addToSegment(segmentBuilder);
            }
            if (type.isInSource()) {
                ++sourceSpan;
            }
            if (!type.isInDestination()) continue;
            ++destSpan;
        }
        if (segmentBuilder != null) {
            hunkBuilder.sourceSpan(sourceSpan).destinationSpan(destSpan).segment((DiffSegment)segmentBuilder.build());
        }
        return hunkBuilder.build();
    }
}

