/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.comment.CommentDeletionException;
import com.atlassian.stash.comment.CommentOutOfDateException;
import com.atlassian.stash.comment.DiffCommentAnchor;
import com.atlassian.stash.comment.NoSuchCommentException;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.event.comment.CommentAddedEvent;
import com.atlassian.stash.event.comment.CommentDeletedEvent;
import com.atlassian.stash.event.comment.CommentEditedEvent;
import com.atlassian.stash.event.comment.CommentRepliedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorDao;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestCommentCounts;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentService;
import com.atlassian.stash.internal.util.ValidationUtils;
import com.atlassian.stash.pull.IllegalPullRequestStateException;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.validation.groups.Create;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pullRequestCommentService")
public class DefaultPullRequestCommentService
extends AbstractService
implements InternalPullRequestCommentService {
    private static final Function<InternalComment, InternalPullRequestDiffCommentAnchor> NO_ANCHOR = new Function<InternalComment, InternalPullRequestDiffCommentAnchor>(){

        public InternalPullRequestDiffCommentAnchor apply(InternalComment comment) {
            return null;
        }
    };
    private static final Function<InternalPullRequestDiffCommentAnchor, InternalComment> TO_COMMENT = new Function<InternalPullRequestDiffCommentAnchor, InternalComment>(){

        public InternalComment apply(InternalPullRequestDiffCommentAnchor anchor) {
            return anchor.getComment();
        }
    };
    private final PullRequestActivityDao activityDao;
    private final PullRequestCommentAnchorDao anchorDao;
    private final StashAuthenticationContext authenticationContext;
    private final CommentDao commentDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final CommentPostProcessor postProcessor;
    private final ScmService scmService;
    private final Validator validator;
    @Autowired
    private CommentUpdateProcessor updateProcessor;

    @Autowired
    public DefaultPullRequestCommentService(PullRequestActivityDao activityDao, PullRequestCommentAnchorDao anchorDao, StashAuthenticationContext authenticationContext, CommentDao commentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, ScmService scmService, Validator validator, CommentPostProcessor postProcessor) {
        this.activityDao = activityDao;
        this.anchorDao = anchorDao;
        this.authenticationContext = authenticationContext;
        this.commentDao = commentDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.postProcessor = postProcessor;
        this.scmService = scmService;
        this.validator = validator;
    }

    @Nonnull
    public Map<InternalChangeLocation, PullRequestCommentCounts> countsByLocation(@Nonnull InternalPullRequest pullRequest) {
        return this.anchorDao.getCountsByLocation(pullRequest.getGlobalId().longValue());
    }

    @Nonnull
    @Transactional
    public InternalComment create(@Nonnull InternalPullRequest pullRequest, @Nonnull String text) {
        return this.createComment(pullRequest, null, text);
    }

    @Nonnull
    @Transactional
    public InternalComment createDiffComment(@Nonnull InternalPullRequest pullRequest, @Nonnull String commentText, @Nonnull String path, String srcPath, int line, @Nonnull DiffSegmentType lineType) {
        return this.createAnchoredComment(pullRequest, commentText, path, srcPath, line, lineType);
    }

    @Nonnull
    @Transactional
    public InternalComment createFileComment(@Nonnull InternalPullRequest pullRequest, @Nonnull String commentText, @Nonnull String path, String srcPath) {
        return this.createAnchoredComment(pullRequest, commentText, path, srcPath, 0, null);
    }

    @Nonnull
    @Transactional
    public InternalComment createReply(@Nonnull InternalPullRequest pullRequest, long parentId, String commentText) {
        return this.createComment(pullRequest, this.getById(pullRequest, parentId), commentText);
    }

    @Transactional
    public boolean delete(@Nonnull InternalPullRequest pullRequest, long commentId, int version) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null) {
            return false;
        }
        this.validateVersion(version, comment.getVersion());
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if ((currentUser == null || ObjectUtils.notEqual((Object)currentUser.getId(), (Object)comment.getAuthor().getId())) && !this.permissionService.hasRepositoryPermission((Repository)pullRequest.getToRef().getRepository(), Permission.REPO_ADMIN)) {
            throw new AuthorisationException(this.i18nService.getKeyedText("stash.service.comment.delete.otheruser", "You may only delete your own comments.", new Object[0]));
        }
        if (!comment.getComments().isEmpty()) {
            throw new CommentDeletionException(this.i18nService.getKeyedText("stash.service.comment.delete.hasreplies", "This comment has replies which must be deleted first.", new Object[0]));
        }
        this.commentDao.delete((Object)InternalConverter.convertToInternalComment((Comment)comment));
        this.eventPublisher.publish((Object)new CommentDeletedEvent((Object)this, (Comment)comment));
        this.eventPublisher.publish((Object)new PullRequestCommentDeletedEvent((Object)this, (PullRequest)pullRequest, (Comment)comment, (Comment)comment.getParent()));
        return true;
    }

    @Nonnull
    public List<InternalPullRequestDiffCommentAnchor> findDiffAnchors(@Nonnull InternalPullRequest pullRequest) {
        return this.findDiffAnchors(pullRequest, null);
    }

    @Nonnull
    public List<InternalPullRequestDiffCommentAnchor> findDiffAnchors(@Nonnull InternalPullRequest pullRequest, String path) {
        PullRequestCommentAnchorSearchCriteria criteria = (PullRequestCommentAnchorSearchCriteria)new PullRequestCommentAnchorSearchCriteria((PullRequest)pullRequest).setPath(path);
        List anchors = this.anchorDao.search(criteria);
        this.postProcessor.processAll(pullRequest.getScopeRepository(), Lists.transform((List)anchors, TO_COMMENT));
        return anchors;
    }

    @Nonnull
    public InternalComment getById(@Nonnull InternalPullRequest pullRequest, long commentId) {
        return this.postProcessor.process(pullRequest.getScopeRepository(), this.getCommentOrFail(commentId));
    }

    public void maybeUpdateComments(@Nonnull InternalPullRequest pullRequest) {
        this.updateProcessor.maybeProcess(pullRequest);
    }

    @Nonnull
    @Transactional
    public InternalComment update(@Nonnull InternalPullRequest pullRequest, long commentId, int version, @Nonnull String text) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)text), (Object)this.i18nService.getText("stash.service.comment.update.requirestext", "Text must be provided when updating a comment.", new Object[0]));
        InternalComment comment = this.getCommentOrFail(commentId, version);
        String previousText = comment.getText();
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.getKeyedText("stash.service.comment.update.anonymous", "Unauthenticated users may not edit comments. Please authenticate to edit your comments.", new Object[0]));
        }
        if (ObjectUtils.notEqual((Object)currentUser.getId(), (Object)comment.getAuthor().getId())) {
            throw new AuthorisationException(this.i18nService.getKeyedText("stash.service.comment.update.otheruser", "You may only edit your own comments.", new Object[0]));
        }
        InternalComment updated = new InternalComment.Builder(comment).text(text).updatedDate(new Date()).build();
        comment = (InternalComment)this.commentDao.update((Object)updated);
        this.eventPublisher.publish((Object)new CommentEditedEvent((Object)this, (Comment)comment, previousText));
        this.eventPublisher.publish((Object)new PullRequestCommentEditedEvent((Object)this, (PullRequest)pullRequest, (Comment)comment, (Comment)comment.getParent(), previousText));
        this.logCommentActivity(pullRequest, CommentAction.EDITED, new Date(), comment, null);
        return this.postProcessor.process(pullRequest.getScopeRepository(), comment);
    }

    @Transactional
    public void updateAnchors(@Nonnull List<InternalPullRequestDiffCommentAnchor> anchors) {
        for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
            this.anchorDao.update((Object)anchor);
        }
    }

    public void updateComments(@Nonnull InternalPullRequest pullRequest, @Nonnull String previousFromHash, @Nonnull String previousToHash) {
        this.updateProcessor.process(pullRequest, previousFromHash, previousToHash);
    }

    private InternalComment createAnchoredComment(InternalPullRequest pullRequest, String text, String path, String srcPath, int line, DiffSegmentType lineType) {
        return this.doCreateComment(pullRequest, null, text, new PullRequestDiffCommentAnchorFunction(pullRequest, path, srcPath, line, lineType));
    }

    private InternalComment createComment(InternalPullRequest pullRequest, InternalComment parent, String text) {
        return this.doCreateComment(pullRequest, parent, text, NO_ANCHOR);
    }

    private InternalComment doCreateComment(InternalPullRequest pullRequest, InternalComment parent, String text, Function<InternalComment, InternalPullRequestDiffCommentAnchor> anchorFunction) {
        CommentAction commentAction;
        InternalPullRequestDiffCommentAnchor anchor;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)text), (Object)this.i18nService.getText("stash.service.comment.new.requirestext", "Text must be provided when adding a comment.", new Object[0]));
        Date modified = new Date();
        InternalComment comment = new InternalComment.Builder().author(InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser())).createdDate(modified).parent(parent).text(text).updatedDate(modified).build();
        comment = (InternalComment)this.commentDao.create((Object)comment);
        if (parent == null) {
            anchor = (InternalPullRequestDiffCommentAnchor)anchorFunction.apply((Object)comment);
            commentAction = CommentAction.ADDED;
            this.eventPublisher.publish((Object)new CommentAddedEvent((Object)this, (Comment)comment, (DiffCommentAnchor)anchor));
            this.eventPublisher.publish((Object)new PullRequestCommentAddedEvent((Object)this, (PullRequest)pullRequest, (Comment)comment, null, (DiffCommentAnchor)anchor));
        } else {
            anchor = null;
            commentAction = CommentAction.REPLIED;
            this.eventPublisher.publish((Object)new CommentRepliedEvent((Object)this, (Comment)comment, (Comment)parent, (Comment)comment.getRoot()));
            this.eventPublisher.publish((Object)new PullRequestCommentRepliedEvent((Object)this, (PullRequest)pullRequest, (Comment)comment, (Comment)parent));
        }
        this.logCommentActivity(pullRequest, commentAction, modified, comment, anchor);
        return this.postProcessor.process(pullRequest.getScopeRepository(), comment);
    }

    private InternalComment getCommentOrFail(long commentId) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null) {
            throw new NoSuchCommentException(this.i18nService.getKeyedText("stash.service.comment.nosuchcomment", "The requested comment does not exist.", new Object[0]));
        }
        return comment;
    }

    private InternalComment getCommentOrFail(long commentId, int version) {
        InternalComment comment = this.getCommentOrFail(commentId);
        this.validateVersion(version, comment.getVersion());
        return comment;
    }

    @Nonnull
    private PullRequestEffectiveDiff getEffectiveDiff(InternalPullRequest pullRequest) {
        PullRequestEffectiveDiff diff = (PullRequestEffectiveDiff)this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
        if (diff == null) {
            throw new IllegalPullRequestStateException(this.i18nService.getKeyedText("stash.service.pullrequest.noeffectivediff", "The effective diff for pull request {0} could not be determined", new Object[]{pullRequest.getId()}));
        }
        return diff;
    }

    private void logCommentActivity(InternalPullRequest pullRequest, CommentAction action, Date when, InternalComment comment, InternalPullRequestDiffCommentAnchor anchor) {
        this.activityDao.create((Object)((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)new InternalPullRequestCommentActivity.Builder().comment(comment).commentAction(action).commentAnchor(anchor).createdDate(when)).pullRequest(pullRequest)).user(InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser()))).build());
    }

    private void validateVersion(int expectedVersion, int actualVersion) {
        if (actualVersion != expectedVersion) {
            throw new CommentOutOfDateException(this.i18nService.getKeyedText("stash.service.comment.outofdate", "You are attempting to modify a comment based on out-of-date information.", new Object[0]), expectedVersion, actualVersion);
        }
    }

    private class PullRequestDiffCommentAnchorFunction
    implements Function<InternalComment, InternalPullRequestDiffCommentAnchor> {
        private final int line;
        private final DiffSegmentType lineType;
        private final String path;
        private final InternalPullRequest pullRequest;
        private final String srcPath;

        public PullRequestDiffCommentAnchorFunction(InternalPullRequest pullRequest, String path, String srcPath, int line, DiffSegmentType lineType) {
            this.line = line;
            this.lineType = lineType;
            this.path = path;
            this.pullRequest = pullRequest;
            this.srcPath = srcPath;
        }

        public InternalPullRequestDiffCommentAnchor apply(InternalComment comment) {
            PullRequestEffectiveDiff diff = DefaultPullRequestCommentService.this.getEffectiveDiff(this.pullRequest);
            InternalPullRequestDiffCommentAnchor.Builder builder = (InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)new InternalPullRequestDiffCommentAnchor.Builder().comment(comment)).fromHash(diff.getSinceId())).path(this.path)).pullRequest(this.pullRequest).srcPath(this.srcPath)).toHash(diff.getUntilId());
            if (this.lineType != null) {
                builder.line(this.line, this.lineType);
            }
            return (InternalPullRequestDiffCommentAnchor)DefaultPullRequestCommentService.this.anchorDao.create((Object)ValidationUtils.validate(DefaultPullRequestCommentService.this.validator, builder.build(), Create.class));
        }
    }
}

