/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.InternalChange;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.PullRequestCommentCounts;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public class CountAttributeChangeCallback
implements ChangeCallback {
    private final Map<InternalChangeLocation, PullRequestCommentCounts> countsByLocation;
    private final ChangeCallback delegate;

    public CountAttributeChangeCallback(@Nonnull ChangeCallback delegate, @Nonnull Map<InternalChangeLocation, PullRequestCommentCounts> countsByLocation) {
        this.countsByLocation = (Map)Preconditions.checkNotNull(countsByLocation, (Object)"countsByLocation");
        this.delegate = (ChangeCallback)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    public boolean onChange(@Nonnull Change change) throws IOException {
        PullRequestCommentCounts counts = this.countsByLocation.get(new InternalChangeLocation.Builder(change).build());
        if (counts != null) {
            AttributeMap attributes = new AttributeMap.Builder().add("activeComments", new String[]{String.valueOf(counts.getActive())}).add("orphanedComments", new String[]{String.valueOf(counts.getOrphaned())}).build();
            ((InternalChange)change).setAttributes(attributes);
        }
        return this.delegate.onChange(change);
    }

    public void onEnd(boolean truncated) throws IOException {
        this.delegate.onEnd(truncated);
    }

    public void onStart() throws IOException {
        this.delegate.onStart();
    }
}

