/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.util.UncheckedOperation;
import com.atlassian.util.concurrent.atomic.AtomicInteger;

public class PullRequestCommentStateGuard {
    private final AtomicInteger unprocessedRecopes = new AtomicInteger(1);

    public void onScopeUpdated() {
        this.unprocessedRecopes.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdate(UncheckedOperation<Void> updateOperation) {
        if (this.unprocessedRecopes.get() == 0) {
            return;
        }
        AtomicInteger atomicInteger = this.unprocessedRecopes;
        synchronized (atomicInteger) {
            int preUpdateCount = this.unprocessedRecopes.get();
            if (preUpdateCount > 0) {
                updateOperation.perform();
                this.unprocessedRecopes.addAndGet(-preUpdateCount);
            }
        }
    }
}

