/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.stash.internal.pull.DefaultMergeRequest;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestMergeVeto;
import com.atlassian.stash.scm.pull.MergeRequest;
import com.atlassian.stash.scm.pull.MergeRequestCheck;
import com.atlassian.stash.scm.pull.MergeRequestCheckModuleDescriptor;
import com.atlassian.stash.scm.pull.MergeRequestCheckService;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mergeRequestCheckService")
@AvailableToPlugins(value=MergeRequestCheckService.class)
@Transactional(readOnly=true)
public class DefaultMergeRequestCheckService
implements MergeRequestCheckService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMergeRequestCheckService.class);
    private final PluginModuleTracker<MergeRequestCheck, MergeRequestCheckModuleDescriptor> mergeChecksTracker;

    @Autowired
    public DefaultMergeRequestCheckService(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.mergeChecksTracker = DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, MergeRequestCheckModuleDescriptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<PullRequestMergeVeto> check(@Nonnull PullRequest pr) {
        DefaultMergeRequest mergeRequest = new DefaultMergeRequest(pr);
        for (MergeRequestCheckModuleDescriptor descriptor : this.mergeChecksTracker.getModuleDescriptors()) {
            MergeRequestCheck module = descriptor.getModule();
            Timer timer = TimerUtils.start((String)String.format("Calling merge request check %s of type %s", descriptor.getCompleteKey(), module.getClass().getName()));
            try {
                module.check((MergeRequest)mergeRequest);
            }
            catch (Exception e) {
                log.warn(String.format("Merge request check %s of type %s failed.", descriptor.getCompleteKey(), module.getClass().getName()), (Throwable)e);
            }
            finally {
                timer.stop();
            }
        }
        return mergeRequest.getVetoes();
    }
}

