/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.pull.SimplePullRequestMergeVeto;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestMergeVeto;
import com.atlassian.stash.scm.pull.MergeRequest;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

class DefaultMergeRequest
implements MergeRequest {
    private final PullRequest pr;
    private final List<PullRequestMergeVeto> vetoes;

    public DefaultMergeRequest(PullRequest pr) {
        this.pr = pr;
        this.vetoes = Lists.newArrayList();
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pr;
    }

    public void veto(@Nonnull String summary, @Nonnull String detailedMessage) {
        this.vetoes.add(new SimplePullRequestMergeVeto(summary, detailedMessage));
    }

    public Collection<PullRequestMergeVeto> getVetoes() {
        return Collections.unmodifiableList(this.vetoes);
    }
}

