/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.plugin.FormFragmentModuleDescriptor;
import com.atlassian.stash.ui.ContextualFormFragment;
import com.atlassian.stash.ui.PluginFormFragments;
import com.atlassian.stash.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.atlassian.stash.view.ViewStreamIOException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginFormFragmentsFactory")
@AvailableToPlugins
public class PluginFormFragmentsFactoryImpl
implements PluginFormFragmentsFactory {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginFormFragmentsFactoryImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public PluginFormFragments forKey(@Nonnull String formKey) {
        return this.forKey(formKey, Maps.newHashMap());
    }

    @Nonnull
    public PluginFormFragments forKey(final @Nonnull String formKey, @Nonnull Map<String, Object> context) {
        Preconditions.checkNotNull((Object)formKey, (Object)"formKey");
        Collection applicableDescriptors = Collections2.filter(this.getFormFragmentDescriptors(), (Predicate)new Predicate<FormFragmentModuleDescriptor>(){

            public boolean apply(FormFragmentModuleDescriptor input) {
                if (!formKey.equals(input.getLocation())) {
                    return false;
                }
                Condition condition = input.getCondition();
                return condition == null || condition.shouldDisplay(Collections.emptyMap());
            }
        });
        return new PluginFormFragmentsImpl(Lists.newArrayList((Iterable)ModuleDescriptorUtils.toSortedModules((Iterable)applicableDescriptors)), context);
    }

    public boolean existsForKey(final @Nonnull String formKey) {
        return Iterables.any(this.getFormFragmentDescriptors(), (Predicate)new Predicate<FormFragmentModuleDescriptor>(){

            public boolean apply(FormFragmentModuleDescriptor input) {
                return formKey.equals(input.getLocation());
            }
        });
    }

    private List<FormFragmentModuleDescriptor> getFormFragmentDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(FormFragmentModuleDescriptor.class);
    }

    private static class PluginFormFragmentsImpl
    implements PluginFormFragments {
        private final Iterable<ContextualFormFragment> formHandlers;
        private final Map<String, Object> context;

        private PluginFormFragmentsImpl(Iterable<ContextualFormFragment> formHandlers, Map<String, Object> context) {
            this.formHandlers = formHandlers;
            this.context = context;
        }

        public String getViewHtml() {
            StringBuilder fieldsHtml = new StringBuilder();
            for (ContextualFormFragment fragment : this.formHandlers) {
                try {
                    fragment.doView((Appendable)fieldsHtml, this.context);
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doView: " + fragment, (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public void validate(Map<String, String[]> requestParams, ValidationErrors errors) {
            for (ContextualFormFragment fragment : this.formHandlers) {
                fragment.validate(requestParams, errors, this.context);
            }
        }

        public String getErrorHtml(Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors) {
            StringBuilder fieldsHtml = new StringBuilder();
            for (ContextualFormFragment fragment : this.formHandlers) {
                try {
                    fragment.doError((Appendable)fieldsHtml, requestParams, fieldErrors, this.context);
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doError: " + fragment, (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public void execute(Map<String, String[]> requestParams) {
            for (ContextualFormFragment fragment : this.formHandlers) {
                fragment.execute(requestParams, this.context);
            }
        }
    }
}

